/*
 * Decompiled with CFR 0.152.
 */
package com.robotium.solo;

import android.app.Instrumentation;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.ScrollView;
import com.robotium.solo.RobotiumUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewFetcher {
    private String windowManagerString;
    private Instrumentation instrumentation;
    private static Class<?> windowManager;

    public ViewFetcher(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.setWindowManagerString();
    }

    public View getTopParent(View view) {
        ViewParent viewParent = view.getParent();
        if (viewParent != null && viewParent instanceof View) {
            return this.getTopParent((View)viewParent);
        }
        return view;
    }

    public View getScrollOrListParent(View view) {
        if (!(view instanceof AbsListView || view instanceof ScrollView || view instanceof WebView)) {
            try {
                return this.getScrollOrListParent((View)view.getParent());
            }
            catch (Exception e) {
                return null;
            }
        }
        return view;
    }

    public ArrayList<View> getAllViews(boolean onlySufficientlyVisible) {
        View[] views = this.getWindowDecorViews();
        ArrayList<View> allViews = new ArrayList<View>();
        View[] nonDecorViews = this.getNonDecorViews(views);
        View view = null;
        if (nonDecorViews != null) {
            for (int i = 0; i < nonDecorViews.length; ++i) {
                view = nonDecorViews[i];
                try {
                    this.addChildren(allViews, (ViewGroup)view, onlySufficientlyVisible);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                if (view == null) continue;
                allViews.add(view);
            }
        }
        if (views != null && views.length > 0) {
            view = this.getRecentDecorView(views);
            try {
                this.addChildren(allViews, (ViewGroup)view, onlySufficientlyVisible);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (view != null) {
                allViews.add(view);
            }
        }
        return allViews;
    }

    public final View getRecentDecorView(View[] views) {
        if (views == null) {
            return null;
        }
        View[] decorViews = new View[views.length];
        int i = 0;
        for (int j = 0; j < views.length; ++j) {
            String nameOfClass;
            View view = views[j];
            if (view == null || !(nameOfClass = view.getClass().getName()).equals("com.android.internal.policy.impl.PhoneWindow$DecorView") && !nameOfClass.equals("com.android.internal.policy.impl.MultiPhoneWindow$MultiPhoneDecorView")) continue;
            decorViews[i] = view;
            ++i;
        }
        return this.getRecentContainer(decorViews);
    }

    private final View getRecentContainer(View[] views) {
        View container = null;
        long drawingTime = 0L;
        for (int i = 0; i < views.length; ++i) {
            View view = views[i];
            if (view == null || !view.isShown() || !view.hasWindowFocus() || view.getDrawingTime() <= drawingTime) continue;
            container = view;
            drawingTime = view.getDrawingTime();
        }
        return container;
    }

    private final View[] getNonDecorViews(View[] views) {
        View[] decorViews = null;
        if (views != null) {
            decorViews = new View[views.length];
            int i = 0;
            for (int j = 0; j < views.length; ++j) {
                View view = views[j];
                if (view == null || view.getClass().getName().equals("com.android.internal.policy.impl.PhoneWindow$DecorView")) continue;
                decorViews[i] = view;
                ++i;
            }
        }
        return decorViews;
    }

    public ArrayList<View> getViews(View parent, boolean onlySufficientlyVisible) {
        ArrayList<View> views = new ArrayList<View>();
        if (parent == null) {
            return this.getAllViews(onlySufficientlyVisible);
        }
        View parentToUse = parent;
        views.add(parentToUse);
        if (parentToUse instanceof ViewGroup) {
            this.addChildren(views, (ViewGroup)parentToUse, onlySufficientlyVisible);
        }
        return views;
    }

    private void addChildren(ArrayList<View> views, ViewGroup viewGroup, boolean onlySufficientlyVisible) {
        if (viewGroup != null) {
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View child = viewGroup.getChildAt(i);
                if (onlySufficientlyVisible && this.isViewSufficientlyShown(child)) {
                    views.add(child);
                } else if (!onlySufficientlyVisible) {
                    views.add(child);
                }
                if (!(child instanceof ViewGroup)) continue;
                this.addChildren(views, (ViewGroup)child, onlySufficientlyVisible);
            }
        }
    }

    public final boolean isViewSufficientlyShown(View view) {
        int[] xyView = new int[2];
        int[] xyParent = new int[2];
        if (view == null) {
            return false;
        }
        float viewHeight = view.getHeight();
        View parent = this.getScrollOrListParent(view);
        view.getLocationOnScreen(xyView);
        if (parent == null) {
            xyParent[1] = 0;
        } else {
            parent.getLocationOnScreen(xyParent);
        }
        if ((float)xyView[1] + viewHeight / 2.0f > this.getScrollListWindowHeight(view)) {
            return false;
        }
        return !((float)xyView[1] + viewHeight / 2.0f < (float)xyParent[1]);
    }

    public float getScrollListWindowHeight(View view) {
        float windowHeight;
        int[] xyParent = new int[2];
        View parent = this.getScrollOrListParent(view);
        if (parent == null) {
            WindowManager windowManager = (WindowManager)this.instrumentation.getTargetContext().getSystemService("window");
            windowHeight = windowManager.getDefaultDisplay().getHeight();
        } else {
            parent.getLocationOnScreen(xyParent);
            windowHeight = xyParent[1] + parent.getHeight();
        }
        parent = null;
        return windowHeight;
    }

    public <T extends View> ArrayList<T> getCurrentViews(Class<T> classToFilterBy, boolean includeSubclasses) {
        return this.getCurrentViews(classToFilterBy, includeSubclasses, null);
    }

    public <T extends View> ArrayList<T> getCurrentViews(Class<T> classToFilterBy, boolean includeSubclasses, View parent) {
        ArrayList<T> filteredViews = new ArrayList<T>();
        ArrayList<View> allViews = this.getViews(parent, true);
        for (View view : allViews) {
            if (view == null) continue;
            Class<?> classOfView = view.getClass();
            if ((!includeSubclasses || !classToFilterBy.isAssignableFrom(classOfView)) && (includeSubclasses || classToFilterBy != classOfView)) continue;
            filteredViews.add(classToFilterBy.cast(view));
        }
        allViews = null;
        return filteredViews;
    }

    public final <T extends View> T getFreshestView(ArrayList<T> views) {
        int[] locationOnScreen = new int[2];
        View viewToReturn = null;
        long drawingTime = 0L;
        if (views == null) {
            return null;
        }
        for (View view : views) {
            view.getLocationOnScreen(locationOnScreen);
            if (locationOnScreen[0] < 0 || view.getDrawingTime() <= drawingTime || view.getHeight() <= 0) continue;
            drawingTime = view.getDrawingTime();
            viewToReturn = view;
        }
        views = null;
        return (T)viewToReturn;
    }

    public View getIdenticalView(View view) {
        if (view == null) {
            return null;
        }
        View viewToReturn = null;
        ArrayList<View> visibleViews = RobotiumUtils.removeInvisibleViews(this.getCurrentViews(view.getClass(), true));
        for (View v : visibleViews) {
            if (!this.areViewsIdentical(v, view)) continue;
            viewToReturn = v;
            break;
        }
        return viewToReturn;
    }

    private boolean areViewsIdentical(View firstView, View secondView) {
        if (firstView.getId() != secondView.getId() || !firstView.getClass().isAssignableFrom(secondView.getClass())) {
            return false;
        }
        if (firstView.getParent() != null && firstView.getParent() instanceof View && secondView.getParent() != null && secondView.getParent() instanceof View) {
            return this.areViewsIdentical((View)firstView.getParent(), (View)secondView.getParent());
        }
        return true;
    }

    public View[] getWindowDecorViews() {
        try {
            Field viewsField = windowManager.getDeclaredField("mViews");
            Field instanceField = windowManager.getDeclaredField(this.windowManagerString);
            viewsField.setAccessible(true);
            instanceField.setAccessible(true);
            Object instance = instanceField.get(null);
            View[] result = Build.VERSION.SDK_INT >= 19 ? ((ArrayList)viewsField.get(instance)).toArray(new View[0]) : (View[])viewsField.get(instance);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setWindowManagerString() {
        this.windowManagerString = Build.VERSION.SDK_INT >= 17 ? "sDefaultWindowManager" : (Build.VERSION.SDK_INT >= 13 ? "sWindowManager" : "mWindowManager");
    }

    static {
        try {
            String windowManagerClassName = Build.VERSION.SDK_INT >= 17 ? "android.view.WindowManagerGlobal" : "android.view.WindowManagerImpl";
            windowManager = Class.forName(windowManagerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }
}

