package todo

import (
  "encoding/json"
  "errors"
  "fmt"
  "os"
  "time"
)

//TODO
// item struct represents a ToDo item
// Members: Task (string) Done (bool) CreateAt (time.Time) CompletedAt (time.Time)
type item struct {
	CompletedAt time.Time
}

// List represents a list of ToDo items
type List []item

//String prints out a formatted list
//Implements the fmt.Stringer interface
func (l *List) String() string {
  formatted := ""

  for k, t := range *l {
    prefix := "  "
    if t.Done {
      prefix = "X "
    }

    // Adjust the item number k to print numbers starting from 1 instead of 0
    formatted += fmt.Sprintf("%s%d: %s\n", prefix, k+1, t.Task)
  }

  return formatted
}

// TODO
// Add creates a new todo item and appends it to the list
func (l *List) Add(task string) {
 
}

//TODO
// Complete method marks a ToDo item as completed by
// setting Done = true and CompletedAt to the current time
func (l *List) Complete(i int) error {
  
  //if i <= 0 || i > len(ls) {
    //return fmt.Errorf("Item %d does not exist", i)
  //}

  return nil
}

//TODO
// Delete method deletes a ToDo item from the list
func (l *List) Delete(i int) error {
  
  return nil
}

// Save method encodes the List as JSON and saves it
// using the provided file name
func (l *List) Save(filename string) error {
  data, err := json.Marshal(l)
  if err != nil {
    return err
  }

  return os.WriteFile(filename, data, 0644)
}

// Get method opens the provided file name, decodes
// the JSON data and parse into a List
func (l *List) Get(filename string) error {
  file, err := os.ReadFile(filename)
  if err != nil {
    if errors.Is(err, os.ErrNotExist) {
      return nil
    }
    return err
  }

  if len(file) == 0 {
    return nil
  }

  return json.Unmarshal(file, l)
}
