def call(String repo, String branch, String serviceName) {
    pipeline {
  agent any
  tools {
        go 'go-1.16'
  }
  options {
    buildDiscarder logRotator(artifactDaysToKeepStr: '', artifactNumToKeepStr: '5', daysToKeepStr: '', numToKeepStr: '5')
  }
  stages {
      
  stage('checkout') {
        steps {
            git branch: branch,
                credentialsId: 'tucker-gitlab-login',
                url: repo
        }
    }
     
    stage('test') {
      steps {
        sh """
            dawn-cli test
        """ 
      }
    }

    stage('build') {
      steps {
        sh """
            dawn-cli build-image -p .
        """ 
      }
    }

    stage('update backend services') {
      steps {
        sh '''
            curl -o docker-compose-dev.yml --header "PRIVATE-TOKEN: y2FHtFXMC8X13onnEfiE" "https://gitlab.cs.umd.edu/api/v4/projects/16574/repository/files/docker-compose-dev.yml/raw?ref=main"
            curl -o prometheus.yml --header "PRIVATE-TOKEN: y2FHtFXMC8X13onnEfiE" "https://gitlab.cs.umd.edu/api/v4/projects/16574/repository/files/prometheus.yml/raw?ref=main"
            curl -o prometheus.rules.yml --header "PRIVATE-TOKEN: y2FHtFXMC8X13onnEfiE" "https://gitlab.cs.umd.edu/api/v4/projects/16574/repository/files/prometheus.rules.yml/raw?ref=main"
            curl -o rabbitmq.conf --header "PRIVATE-TOKEN: y2FHtFXMC8X13onnEfiE" "https://gitlab.cs.umd.edu/api/v4/projects/16574/repository/files/rabbitmq.conf/raw?ref=main"
        '''
        sh "dawn-cli update -s ${serviceName}"
      }
    }

  }
  post {
        always {
              cobertura autoUpdateHealth: false, autoUpdateStability: false, coberturaReportFile: '**/coverage.xml', enableNewApi: true, failUnhealthy: false, failUnstable: false, lineCoverageTargets: '80, 40, 60', maxNumberOfBuilds: 0, onlyStable: false, sourceEncoding: 'ASCII', zoomCoverageChart: false
        }
    }
}
}