gdd_collection = require('../models/gdd.js');
utils = require('../lib/utils');

var may_31st = 150
var sept_1st = 243
var nov_30th = 330

function is_leap_year(year) {
    if ((year % 4) == 0) {
        if ((year % 100) == 0) {
            if ((year % 400) == 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return true;
        }
    } else {
        return false; 
    }
}

function send_response(message, gdds, data, res) {
    res.json({
        message: message,
        date: data["last_date"],
        data: gdds,
        closest_lon: data["location"]["coordinates"][0],
        closest_lat: data["location"]["coordinates"][1]
    })
}

function find(collection, query, res, freeze_temp) {
    var total_years = new Date().getFullYear() -  new Date(1981, 0, 1, 0, 0, 0, 0).getFullYear() - 1;
    
    collection.find(query).limit(total_years).then(function(data) {
        var last_freezing_dates = [];
        var first_freezing_dates = [];
        for (var y = 0; y < total_years; y ++){

            // console.log(data[i]["location"]);
            var year = data[y]["year"];
            if (is_leap_year(year)) {
                var year_may_31st = may_31st + 1;
                var year_sept_1st = sept_1st + 1;
                var year_nov_30th = nov_30th + 1;
            } else {
                var year_may_31st = may_31st;
                var year_sept_1st = sept_1st;
                var year_nov_30th = nov_30th;
            }

            var min_temps = data[y]['min_temps'];

            var last = 0;
            for (var i = 0; i < year_may_31st; i++) {
                if (min_temps[i] <= freeze_temp) {
                    last = i;
                } 
            }

            var last_date = new Date(year, 0, 1, 0, 0, 0, 0);
            last_date.setDate(last_date.getDate() + last);          
            last_date = new Date((1 + last_date.getMonth()).toString() + "//" + last_date.getDate().toString() + "//" + new Date().getFullYear().toString());
            last_freezing_dates.push(last_date);

            var first = 0;
            for (var i = year_sept_1st; i < year_nov_30th; i++) {
                if (min_temps[i] <= freeze_temp) {
                    first = i;
                    break;
                } 
            }

            var first_date = new Date(year, 0, 1, 0, 0, 0, 0);
            first_date.setDate(first_date.getDate() + first);          
            first_date = new Date((1 + first_date.getMonth()).toString() + "//" + first_date.getDate().toString() + "//" + new Date().getFullYear().toString());
            first_freezing_dates.push(first_date);           
        }

        res.json({
            message: "first and last freezing dates for every year from 1981 to last full year",
            first_freezing_dates: first_freezing_dates,
            last_freezing_dates: last_freezing_dates,
            closest_lon: data[0]["location"]["coordinates"][0],
            closest_lat: data[0]["location"]["coordinates"][1]
        });


    }, function(err) {
        res.status(500).send({"internal error": err})
    })
    
}


exports.freezing_dates = function (req, res) {
    var product = req.params.product;
    var freeze_temp = req.params.temperature;

    var latitude = parseFloat(req.body.latitude)
    var longitude = parseFloat(req.body.longitude)

    var query = {
        location: { 
            "$near": {
                "$geometry": {
                    "type": "Point", 
                    "coordinates": [longitude, latitude]
                },
            },
        },
    }

    errors = []

    if (latitude < 24.083334 || latitude > 49.916668) {
        errors.push({
            parameter_error: "latitude",
            message: latitude.toString() + " is out of bounds for freezing date calculations. Must be between 24.083334 - 49.916668"
        });
    }   

    if (longitude < -125 || longitude > -66.5) {
        errors.push({
            parameter_error: "longitude",
            message: longitude.toString() + " is out of bounds for freezing date calculations. Must be between -125.0 - -66.5"
        });
    }

    if (errors.length > 0) {
        res.status(400).send({
            errors: errors
        })
    }

    var projection = {
        min_temps: 1,
        max_temps: 1,
        location: 1,
    }


    find(gdd_collection, query, res, freeze_temp);
    
   
};