gdd_collection = require('../models/gdd.js');
gdd_current_collection = require('../models/gdd_current.js');
gdd_normal_collection = require('../models/normals.js');
utils = require('../lib/utils');

function send_response(message, gdds, data, res) {
    res.json({
        message: message,
        date: data["last_date"],
        data: gdds,
        closest_lon: data["location"]["coordinates"][0],
        closest_lat: data["location"]["coordinates"][1]
    })
}

function find(collection, query, projection, t_base, res, product) {
    collection.findOne(query, projection).then(function(data) {
        var min_temps = data["min_temps"]
        var max_temps = data["max_temps"]
        var gdds = [];
        
        var min_temp = 0
        var max_temp = 0

        var gdd_sum = 0;
        
        for (var i = 0; i < min_temps.length; i++) {
            gdd_value = utils.calculate_gdd(min_temps[i], max_temps[i], t_base, product);
            gdd_value = Math.round(gdd_value);
            gdd_sum += gdd_value
            gdds.push(gdd_sum)
        }
        send_response("Accumulated GDDs", gdds, data, res);
    }, function(err) {
        res.status(500).send({"internal error": err})
    })
}

function find_normal(collection, query, projection, t_base, res, product) {
    collection.findOne(query, projection).then(function(data) {
        gdd_base = [];
        if (product == "corn") {
            gdd_base = data["corn_normals_gdd_base"];
        } else {
            gdd_base = data["normals_gdd_base"];
        }
    
        var gdds = [];
        
        var min_temp = 0
        var max_temp = 0

        var gdd_sum = 0;
        
        for (var i = 0; i < gdd_base.length; i++) {
            gdd_value = (gdd_base[i] - t_base);//utils.calculate_gdd(min_temps[i], max_temps[i], t_base, product);
            gdd_value = gdd_value < 0 ? 0 : gdd_value;
            gdd_value = Math.round(gdd_value);
            
            gdd_sum += gdd_value
            gdds.push(gdd_sum)
        }
        send_response("Accumulated GDDs", gdds, data, res);
    }, function(err) {
        res.status(500).send({"internal error": err})
    })
}


exports.accumulated_gdd = function (req, res) {

    var year = parseInt(req.params.year);
    var product = req.params.product;

    var latitude = parseFloat(req.body.latitude)
    var longitude = parseFloat(req.body.longitude)

    var query = {
        location: { 
            "$near": {
                "$geometry": {
                    "type": "Point", 
                    "coordinates": [longitude, latitude]
                },
            },
        },
        year: year,
    }

    var t_base = 50

    errors = []

    if (year < 1981 || year > new Date().getFullYear()) {
        errors.push({
            parameter_error: "year",
            message: year.toString() + " is out of bounds for GDD calculations. Must be between 1981 - Current Year"
        });
    }

    if (latitude < 24.083334 || latitude > 49.916668) {
        errors.push({
            parameter_error: "latitude",
            message: latitude.toString() + " is out of bounds for GDD calculations. Must be between 24.083334 - 49.916668"
        });
    }

    if (req.body.hasOwnProperty("t_base")) {
        t_base = parseFloat(req.body.t_base);
    } else {
        out = utils.product_base_switch(product, errors, t_base);
        t_base = out.t_base;
        errors = out.errors;
    }
    

    if (longitude < -125 || longitude > -66.5) {
        errors.push({
            parameter_error: "longitude",
            message: longitude.toString() + " is out of bounds for GDD calculations. Must be between -125.0 - -66.5"
        });
    }

    if (errors.length > 0) {
        res.status(400).send({
            errors: errors
        })
    }

    var projection = {
        min_temps: 1,
        max_temps: 1,
        location: 1,
    }


    if (year != new Date().getFullYear()) {
        find(gdd_collection, query, projection, t_base, res, product);
    } else {
        find(gdd_current_collection, query, projection, t_base, res, product);
    }
   
};


exports.accumulated_normal_gdd = function (req, res) {

    var product = req.params.product;

    var latitude = parseFloat(req.body.latitude)
    var longitude = parseFloat(req.body.longitude)

    var query = {
        location: { 
            "$near": {
                "$geometry": {
                    "type": "Point", 
                    "coordinates": [longitude, latitude]
                },
            },
        },
    }

    var t_base = 50

    errors = []

    if (latitude < 24.083334 || latitude > 49.916668) {
        errors.push({
            parameter_error: "latitude",
            message: latitude.toString() + " is out of bounds for GDD calculations. Must be between 24.083334 - 49.916668"
        });
    }

    if (req.body.hasOwnProperty("t_base")) {
        t_base = parseFloat(req.body.t_base);
    } else {
        out = utils.product_base_switch(product, errors, t_base);
        t_base = out.t_base;
        errors = out.errors;
    }
    

    if (longitude < -125 || longitude > -66.5) {
        errors.push({
            parameter_error: "longitude",
            message: longitude.toString() + " is out of bounds for GDD calculations. Must be between -125.0 - -66.5"
        });
    }

    if (errors.length > 0) {
        res.status(400).send({
            errors: errors
        })
    }

    var projection = {
        normals_gdd_base: 1,
        corn_normals_gdd_base: 1,
        location: 1,
    }


    find_normal(gdd_normal_collection, query, projection, t_base, res, product);   
};