normals_collection = require('../models/normals.js');
utils = require('../lib/utils');


var ci_convert = {
    80: 1.282,
    85: 1.440,
    90: 1.645,
    95: 1.960,
    99: 2.576,
    99.5: 2.807,
    99.9: 3.291
}

function send_response(message, gdds, data, res) {
    res.json({
        message: message,
        date: data["last_date"],
        data: gdds,
        closest_lon: data["location"]["coordinates"][0],
        closest_lat: data["location"]["coordinates"][1]
    })
}

function find(collection, query, projection, t_base, res, product, confidence_interval) {
    var total_years = new Date().getFullYear() -  new Date(1981, 0, 1, 0, 0, 0, 0).getFullYear() - 1;
    var z_score = ci_convert[confidence_interval];
    collection.findOne(query, projection).then(function(data) {
        // console.log(data);
        var gdd_base = []
        var gdd_std = []
        if (product == "corn") {
            gdd_base = data["corn_global_mean"];
            gdd_std = data["corn_std"];
        } else {
            gdd_base = data["global_mean"];
            gdd_std = data["main_std"];
        }
        
        var min_gdds = [];
        var max_gdds = [];
        var gdd_value = 0
        var min_gdd_value = 0;
        var max_gdd_value = 0;
        var gdd_sum = 0;
        var min_gdd_sum = 0;
        var max_gdd_sum = 0;

        for (var i = 0; i < gdd_base.length; i++) {
            gdd_value = gdd_base[i];

            max_gdd_value = (gdd_value + (gdd_std[i]/(total_years ** 0.5) * z_score)) - t_base
            min_gdd_value = (gdd_value - (gdd_std[i]/(total_years ** 0.5) * z_score)) - t_base
            
            min_gdd_value = min_gdd_value < 0 ? 0 : min_gdd_value;
            max_gdd_value = max_gdd_value < 0 ? 0 : max_gdd_value;

            min_gdd_value = Math.round(min_gdd_value);
            max_gdd_value = Math.round(max_gdd_value);

            min_gdd_sum += min_gdd_value
            max_gdd_sum += max_gdd_value

            min_gdds.push(min_gdd_sum);
            max_gdds.push(max_gdd_sum);
        }
        res.json({
            message: "confidence interval bounds gdd",
            minimum: min_gdds,
            maximum: max_gdds,
            closest_lon: data["location"]["coordinates"][0],
            closest_lat: data["location"]["coordinates"][1]
        });
    }, function(err) {
        res.status(500).send({"internal error": err})
    })
}


exports.confidence_interval = function (req, res) {
    var product = req.params.product;

    var latitude = parseFloat(req.body.latitude)
    var longitude = parseFloat(req.body.longitude)
    var confidence_interval = 90

    if (req.body.hasOwnProperty("confidence_interval")) {
        confidence_interval = parseFloat(req.body.confidence_interval);
    }

    if (ci_convert.hasOwnProperty(confidence_interval) == false) {
        errors.push({
            parameter_error: "confidence interval",
            message: "confidence interval must be 80, 85, 90, 95, 99, 99.5 or 99.9"
        });
    }

    var query = {
        location: { 
            "$near": {
                "$geometry": {
                    "type": "Point", 
                    "coordinates": [longitude, latitude]
                },
            },
        },
    }

    var t_base = 50

    errors = []

    if (latitude < 24.083334 || latitude > 49.916668) {
        errors.push({
            parameter_error: "latitude",
            message: latitude.toString() + " is out of bounds for GDD calculations. Must be between 24.083334 - 49.916668"
        });
    }

 
    out = utils.product_base_switch(product, errors, t_base);
    t_base = out.t_base;
    errors = out.errors;
    

    if (longitude < -125 || longitude > -66.5) {
        errors.push({
            parameter_error: "longitude",
            message: longitude.toString() + " is out of bounds for GDD calculations. Must be between -125.0 - -66.5"
        });
    }

    if (errors.length > 0) {
        res.status(400).send({
            errors: errors
        })
    }


    find(normals_collection, query, {}, t_base, res, product, confidence_interval);
    
   
};