normals_collection = require('../models/normals.js');
utils = require('../lib/utils');

function find(collection, query, projection, t_base, res, product) {
    collection.findOne(query).then(function(data) {
        gdd_base = [];
        if (product == "corn") {
            gdd_base = data["corn_normals_gdd_base"];
        } else {
            gdd_base = data["normals_gdd_base"];
        }
    
        var gdds = [];
        
        var min_temp = 0
        var max_temp = 0

        var gdd_sum = 0;
        
        for (var i = 0; i < gdd_base.length; i++) {
            gdd_value = (gdd_base[i] - t_base);//utils.calculate_gdd(min_temps[i], max_temps[i], t_base, product);
            gdd_value = gdd_value < 0 ? 0 : gdd_value;
            gdd_value = Math.round(gdd_value);

            gdds.push(gdd_value)
        }

        res.json({
            message: "30-year Normal GDDs",
            data: gdds,
            closest_lon: data["location"]["coordinates"][0],
            closest_lat: data["location"]["coordinates"][1]
        })
    }, function(err) {
        res.status(500).send({"internal error": err})
    })
}


exports.normal = function (req, res) {

    var product = req.params.product;

    var latitude = parseFloat(req.body.latitude)
    var longitude = parseFloat(req.body.longitude)
    
    var query = {
        location: { 
            "$near": {
                "$geometry": {
                    "type": "Point", 
                    "coordinates": [longitude, latitude]
                },
            },
        },
    }

    var projection = {
        min_temps: 1,
        max_temps: 1,
        location: 1,
    }
    
    var t_base = 50

    errors = []

    if (latitude < 24.083334 || latitude > 49.916668) {
        errors.push({
            parameter_error: "latitude",
            message: latitude.toString() + " is out of bounds for GDD calculations. Must be between 24.083334 - 49.916668"
        });
    }

    if (req.body.hasOwnProperty("t_base")) {
        t_base = parseFloat(req.body.t_base);
    } else {
        out = utils.product_base_switch(product, errors, t_base);
        t_base = out.t_base;
        errors = out.errors;
    }

    if (longitude < -125 || longitude > -66.5) {
        errors.push({
            parameter_error: "longitude",
            message: longitude.toString() + " is out of bounds for GDD calculations. Must be between -125.0 - -66.5"
        });
    }

    if (errors.length > 0) {
        res.status(400).send({
            errors: errors
        })
    }

    find(normals_collection, query, projection, t_base, res, product);
};