const gdd = require("../models/gdd");

function product_base_switch(product, errors, t_base) {
    switch (product) {
        case "corn":
        case "soybean":
        case "sunflower":
        case "tomato":
        case "sugar_beet":
        case "peanut":
            t_base = 50;
            break;
        case "cotton":
            t_base = 57.2;
            break;
        case "potato":
            t_base = 44.6;
            break;
        case "wheat":
            t_base = 41.9;
            break;
        case "pea":
        case "oat":
            t_base = 40.1;
            break;
        case "spring_wheat":
            t_base= 32;
            break;
        case "rice":
            t_base = 46.4;
            break;
        case "sorghum":
            t_base = 46.4;
            break;
        default:
            errors.push({
                parameter_error: "product",
                message: product + " is not available for GDD calculations"
            });
            break;
    }
    return {
        t_base: t_base,
        errors: errors
    }
}


function calculate_gdd(min_temp, max_temp, t_base, product) {
    var gdd = 0;
    if (product == "corn") {
        min_temp = min_temp >= 50 ? min_temp : 50;
        min_temp = min_temp <= 86 ? min_temp : 86;
        max_temp = max_temp >= 50 ? max_temp : 50;
        max_temp = max_temp <= 86 ? max_temp : 86;
        mean = ((max_temp + min_temp) / 2);
        return mean - t_base;
    } else {
        mean = ((max_temp + min_temp) / 2);
        return calculated_gdd_mean(mean, t_base);
    }
    return gdd
}

function calculated_gdd_mean(mean, t_base) {
    var values = mean - t_base;
    values = values < 0 ? 0 : values;
    return values;
}

module.exports.product_base_switch = product_base_switch;
module.exports.calculate_gdd = calculate_gdd;
module.exports.calculated_gdd_mean = calculated_gdd_mean;