var mongoose = require('mongoose');
//schema
var normalsSchema = mongoose.Schema({
    id_: {
        type: String,
        required: true
    },
    location: {
        type: {
            type: String,
            enum: ['Point', 'Polygon']
        },
        coordinates: [Number],
    },
    prism_lat: {
        type: Number,
        required: true
    },
    prism_lon: {
        type: Number,
        required: true
    },
    normals_gdd_base: {
        type: Array,
    },
    corn_normals_gdd_base: {
        type: Array,
    },
    corn_std: {
        type: Array,
    },
    main_std: {
        type: Array,
    },
    global_mean: {
        type: Array,
    },
    corn_global_mean: {
        type: Array,
    }
});

var Model = module.exports = mongoose.model('normals', normalsSchema, "normals");
