const router = require('express').Router();
const accController = require("./controllers/gddAccumulatedController")
const controller = require("./controllers/gddController")
const normController = require("./controllers/gddNormalController")
const freezingDatesController = require("./controllers/freezingDatesController")
const confidenceIntervalController = require("./controllers/gddConfidenceInterval")

router.route("/:product/daily/:year/accumulated").post(accController.accumulated_gdd)
router.route("/:product/daily/:year").post(controller.year_gdd)
router.route("/:product/normal").post(normController.normal)
router.route("/:product/confidence").post(confidenceIntervalController.confidence_interval)
router.route("/:product/normal/accumulated").post(accController.accumulated_normal_gdd)
router.route("/freezing/:temperature").post(freezingDatesController.freezing_dates)

module.exports = router;
