var mongoose = require('mongoose');
//schema
var gddCurrentSchema = mongoose.Schema({
    id_: {
        type: String,
        required: true
    },
    location: {
        type: {
            type: String,
            enum: ['Point', 'Polygon']
        },
        coordinates: [Number],
    },
    prism_lat: {
        type: Number,
        required: true
    },
    prism_lon: {
        type: Number,
        required: true
    },
    last_date: {
        type: Date,
        default: Date.now
    },
    year: {
        type: Number,
        default: 0
    },
    min_temps: {
        type: Array,
    },
    max_temps: {
        type: Array,
    }
});

var Model = module.exports = mongoose.model('gdd_current', gddCurrentSchema, "gdd_current");
