var mongoose = require('mongoose');
//schema
var normalsSchema = mongoose.Schema({
    id_: {
        type: String,
        required: true
    },
    location: {
        type: {
            type: String,
            enum: ['Point', 'Polygon']
        },
        coordinates: [Number],
    },
    prism_lat: {
        type: Number,
        required: true
    },
    prism_lon: {
        type: Number,
        required: true
    },
    min_temps: {
        type: Array,
    },
    max_temps: {
        type: Array,
    },
});

var Model = module.exports = mongoose.model('normals', normalsSchema, "normals");
