
function product_base_switch(product, errors) {
    switch (product) {
        case "soybean":
        case "corn":
        case "sunflower":
        case "tomato":
        case "sugar_beat":
            t_base = 50;
            t_min = 50;
            break;
        case "potato":
            t_base = 44.6;
            t_min = 44.6; // NEED TO ASK ABOUT MIN AND MAX TEMPS IN DAY. SHOULD T_MIN BE SET EQUAL TO T_BASE IF IT IS LESS THAN T_BASE?
            break;
        case "wheat":
            t_base = 41.9;
            t_min = 41.9;
            break;
        case "peas":
            t_base = 41;
            t_min = 41;
            break;
        case "brussels_sprout":
        case "parsley":
        case "cabbage":
            t_base = 32;
            t_min = 32;
            break;
        default:
            errors.push({
                parameter_error: "product",
                message: product + " is not available for GDD calculations"
            });
            break;
    }
    return {
        t_base: t_base,
        t_min: t_min,
        errors: errors
    }
}

module.exports.product_base_switch = product_base_switch;