
let router = require('express').Router();

var gddController = require('./gddController');
/**
 * @swagger        
 * /api/{product}/daily/{year}:
 *      post:
 *          summary: Returns GDD data
 *          description: Returns GDD data for a specific product, year, lat, and lon
 *          produces:
 *              - application/json
 *          consumes:
 *              - application/json
 *          parameters:
 *            - in: path
 *              name: product
 *              required: true
 *              description: Agricultural product to calculate gdd for
 *              schema:
 *                  type: string
 *                  enum: [corn, soybean, sugar_beet, sunflower, tomato, potato, wheat, peas, parsley, brussels_sprouts, cabbage]
 *            - in: path
 *              name: year
 *              required: true
 *              description: Year to calculate gdd on
 *              schema:
 *                  type: integer
 *                  minimum: 1981
 *          requestBody:
 *              content:
 *                  application/json:
 *                      schema:
 *                          type: object
 *                          required:
 *                              - longitude
 *                              - latitude
 *                          properties:
 *                              latitude:
 *                                  description: latitude to calculate gdd on
 *                                  type: number
 *                                  minimum: 24.083334
 *                                  maximum: 49.916668
 *                                  example: 38.99
 *                              longitude:
 *                                  description: longitude to calculate gdd on
 *                                  type: number
 *                                  minimum: -125.0
 *                                  maximum: -66.5
 *                                  example: -76.94
 *                              t_base:
 *                                  description: Base temperature to calculate gdd on, in fahrenheit. NOT REQUIRED
 *                                  type: number
 *                                  example: 50
 *                  
 *          responses:
 *              200:
 *                  description: Success
 *                  content:
 *                      application/json:
 *                          schema:
 *                              type: object
 *                              properties:
 *                                  message:
 *                                      type: string
 *                                      example: GDDs
 *                                  date:
 *                                      type: string
 *                                      format: date
 *                                  data:
 *                                      type: array
 *                                      items:
 *                                          type: number
 *                                      minItems: 1
 *                                      maxItems: 365
 *                                  closest_lat:
 *                                      type: number
 *                                      minimum: 24.083334
 *                                      maximum: 49.916668
 *                                      example: 38.99
 *                                  closest_lon:
 *                                      type: number
 *                                      minimum: -125.0
 *                                      maximum: -66.5
 *                                      example: -76.94
 *              400:
 *                  description: Bad Request
 *                  content:
 *                      application/json:
 *                          schema:
 *                              type: object
 *                              properties:
 *                                  errors:
 *                                      type: array
 *                                      items:
 *                                          type: object
 *                                          properties:
 *                                              parameter_error:
 *                                                  type: string
 *                                                  example: latitude
 *                                              message:
 *                                                  type: string
 *                                                  example: 22.5 is out of bounds for GDD calculations. Must be between 24.083334 - 49.916668
 * 
/api/{product}/normal:
 *      post:
 *          summary: Returns GDD data on a 30 year normal
 *          description: Returns GDD normals for a specific lat, and lon
 *          parameters:
 *            - in: path
 *              name: product
 *              required: true
 *              description: Agricultural product to calculate gdd for
 *              schema:
 *                  type: string
 *                  enum: [corn, soybean, sugar_beet, sunflower, tomato, potato, wheat, peas, parsley, brussels_sprouts, cabbage]
 *          requestBody:
 *              content:
 *                  application/json:
 *                      schema:
 *                          type: object
 *                          required:
 *                              - longitude
 *                              - latitude
 *                          properties:
 *                              latitude:
 *                                  description: latitude to calculate gdd on
 *                                  type: number
 *                                  minimum: 24.083334
 *                                  maximum: 49.916668
 *                                  example: 38.99
 *                              longitude:
 *                                  description: longitude to calculate gdd on
 *                                  type: number
 *                                  minimum: -125.0
 *                                  maximum: -66.5
 *                                  example: -76.94
 *                              t_base:
 *                                  description: Base temperature to calculate gdd on, in fahrenheit. NOT REQUIRED
 *                                  type: number
 *                                  example: 50
 *                  
 *          responses:
 *              200:
 *                  description: Success
 *                  content:
 *                      application/json:
 *                          schema:
 *                              type: object
 *                              properties:
 *                                  message:
 *                                      type: string
 *                                      example: 30-year normal GDDs
 *                                  data:
 *                                      type: array
 *                                      items:
 *                                          type: number
 *                                  closest_lat:
 *                                      type: number
 *                                      minimum: 24.083334
 *                                      maximum: 49.916668
 *                                      example: 38.99
 *                                  closest_lon:
 *                                      type: number
 *                                      minimum: -125.0
 *                                      maximum: -66.5
 *                                      example: -78.5
 *              400:
 *                  description: Bad Request
 *                  content:
 *                      application/json:
 *                          schema:
 *                              type: object
 *                              properties:
 *                                  errors:
 *                                      type: array
 *                                      items:
 *                                          type: object
 *                                          properties:
 *                                              parameter_error:
 *                                                  type: string
 *                                                  example: latitude
 *                                              message:
 *                                                  type: string
 *                                                  example: 22.5 is out of bounds for GDD calculations. Must be between 24.083334 - 49.916668
 * 
 * 
 *                  
 *                          
 *                       
 *                          
 *          
*/
router.route('/:product/daily/:year')
    .post(gddController.year_gdd)

router.route('/:product/normal')
    .post(gddController.normal)

module.exports = router;



