const cors = require('cors');
let mongoose = require('mongoose');
const swaggerJSDoc = require('swagger-jsdoc');
const swaggerUi = require('swagger-ui-express');

var express = require("express");

require('./models/gdd.js');
require('./models/gdd_current.js');
require('./models/normals.js');
  
const port = 4000;

const app = express();

let apiRoutes = require("./routes")

app.use(express.json());
app.use(express.urlencoded({extended: true}));
app.use(cors());
app.use('/api', apiRoutes);


const dbPath = "mongodb+srv://gdd-server:u8i3icLAJXjZEhTs@cluster0.wdxf4.mongodb.net/gdd_database";
const options = {useNewUrlParser: true, useUnifiedTopology: true}
const mongo = mongoose.connect(dbPath, options);

const swaggerDefinition = {
    openapi: '3.0.0',
    info: {
      title: 'Express API for GDD Server',
      version: '1.0.0',
    },
  };
  
  const swagger_options = {
    swaggerDefinition,
    apis: ['./routes.js'],
  };

const swaggerSpec = swaggerJSDoc(swagger_options);

app.use('/docs', swaggerUi.serve, swaggerUi.setup(swaggerSpec));

app.listen(port, function () {
    console.log("Server is running on port "+ port);
});

mongo.then(() => {
    console.log('connected');
}, error => {
    console.log(error, 'error');
})

