package controllers

import (
	"gitlab.cs.umd.edu/dawn/dawn-go-common/common"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/services"

	"github.com/gofiber/fiber/v2"
)

// GetCSVFile godoc
// @Summary Get gdd data csv
// @Tags Gdd
// @Description Get gdd data csv
// @Accept  json
// @Produce  text/csv
// @Failure 400 {object} common.StandardError
// @Param analog query boolean false "Add analog data to csv"
// @Param cfs query boolean false "Add cfs data to csv"
// @Param cfs_upper query boolean false "Add cfs upper bound data to csv"
// @Param cfs_lower query boolean false "Add cfs lower bound data to csv"
// @Param comparison query boolean false "Add comparison year data to csv"
// @Param first_freezing query boolean false "Add first freezing date data to csv"
// @Param gefs query boolean false "Add gefs data to csv"
// @Param last_freezing query boolean false "Add last freezing date data to csv"
// @Param maximum query boolean false "Add maximum boundary of confidence interval data to csv"
// @Param minimum query boolean false "Add minimum boundary of confidence interval data to csv"
// @Param normals query boolean false "Add thirty year normal data to csv"
// @Param primary query boolean false "Add primary GDD data to csv"
// @Param comparison_year query int false "Comparison year to use"
// @Param product query string true "Crop to calculate gdd for" Enums(corn, soybean, sunflower, tomato, sugar_beet, peanut, cotton, potato, wheat, pea, oat, spring_wheat, rice, sorghum)
// @Param range query number false "Confidence interval percentage"
// @Param temperature query int false "Freezing date temperature"
// @Param year query int false "Year to get primary data for"
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Router /api/weather/gdd/csv [get]
func GetCSVFile(c *fiber.Ctx) error {
	request := models.CSVRequest{}.Build(c)
	ctx := common.DawnCtx{FiberCtx: c}
	fileText := services.GetDataDownload(ctx, request)
	e := c.Status(fiber.StatusOK).SendString(fileText)
	return e
}
