package controllers

import (
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/services"

	"github.com/gofiber/fiber/v2"
)

// GetFreezingDates godoc
// @Summary get freezing dates
// @Tags Freezing Dates
// @Description get freezing dates
// @Accept  json
// @Produce  json
// @Success 200 {object} models.FreezingDateResponse
// @Failure 400 {object} common.StandardError
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Param freezing_temp query number true "Freezing temperature to use"
// @Router /api/weather/freezing-dates [get]
func GetFreezingDates(c *fiber.Ctx) error {
	request := models.FreezingDateRequest{}.Build(c)
	return c.Status(fiber.StatusOK).JSON(services.GetFreezingDate(request))
}
