package controllers

import (
	"gitlab.cs.umd.edu/dawn/dawn-go-common/common"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/services"

	"github.com/gofiber/fiber/v2"
)

// GetSeedList godoc
// @Summary Get list of seeds in database
// @Tags GDD Seed Data
// @Description Get list of seeds in database
// @Accept  json
// @Produce  json
// @Success 200 {object} models.SeedListResponse
// @Failure 400 {object} common.StandardError
// @Param product query string true "Crop type to use" Enums(corn, soybean)
// @Router /api/weather/gdd/seeds [get]
func GetSeedList(c *fiber.Ctx) error {
	request := models.SeedListRequest{Product: c.Query("product")}
	return c.Status(fiber.StatusOK).JSON(
		services.GetSeedList(c, request),
	)
}

// GetCornSeedMaturityDate godoc
// @Summary Get estimated maturity date from corn seed (uses CFS data if current GDUs are less than the crop maturity)
// @Tags GDD Seed Data
// @Description Get estimated maturity date from corn seed
// @Accept  json
// @Produce  json
// @Success 200 {object} models.CornMaturityResponse
// @Failure 400 {object} common.StandardError
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Param seed query string true "Corn seed to use"
// @Param month query number true "month planted"
// @Param date query number true "date planted"
// @Router /api/weather/gdd/seeds/corn [get]
func GetCornSeedMaturityDate(c *fiber.Ctx) error {
	ctx := common.DawnCtx{FiberCtx: c}
	request := models.BuildCornMaturityRequest(c)
	return c.Status(fiber.StatusOK).JSON(
		services.GetCornMaturityDate(ctx, request),
	)
}
