package services

import (
	"time"

	"gitlab.cs.umd.edu/dawn/dawn-go-common/common"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models/enums"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence/entities"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/utils"
)

func GetFullYearGddValues(ctx common.DawnCtx, request models.GddRequest) models.GddResponse {
	product := enums.GetProductFromString(request.Product)
	var gdds entities.Gdd
	if request.Year == time.Now().Year() {
		gdds = persistence.CurrentGddFindFirstByYearAndLocation(ctx, request.BuildLocation())
		gdds2 := persistence.CfsFindAllByLocation(request.BuildLocation())
		gdds.MaxTemps = append(gdds.MaxTemps, gdds2.MaxTemps...)
		gdds.MinTemps = append(gdds.MinTemps, gdds2.MinTemps...)
	} else {
		gdds = persistence.GddFindFirstByYearAndLocation(request.Year, request.BuildLocation())
	}
	returnGdds := models.GddResponse{
		Product:          product.Name,
		ClosestLatitude:  gdds.Location.Coordinates[1],
		ClosestLongitude: gdds.Location.Coordinates[0],
		GddValues:        utils.CalculateGddValues(gdds.MinTemps, gdds.MaxTemps, product, request.Accumulate),
		LastDate:         gdds.LastDate.Time(),
	}
	return returnGdds
}

func GetGddValues(ctx common.DawnCtx, request models.GddRequest) models.GddResponse {
	product := enums.GetProductFromString(request.Product)
	var gdds entities.Gdd
	if request.Year == time.Now().Year() {
		gdds = persistence.CurrentGddFindFirstByYearAndLocation(ctx, request.BuildLocation())
	} else {
		gdds = persistence.GddFindFirstByYearAndLocation(request.Year, request.BuildLocation())
	}
	returnGdds := models.GddResponse{
		Product:          product.Name,
		ClosestLatitude:  gdds.Location.Coordinates[1],
		ClosestLongitude: gdds.Location.Coordinates[0],
		GddValues:        utils.CalculateGddValues(gdds.MinTemps, gdds.MaxTemps, product, request.Accumulate),
		LastDate:         gdds.LastDate.Time(),
	}
	return returnGdds
}

func GetNormalValues(request models.GddRequest) models.GddResponse {
	product := enums.GetProductFromString(request.Product)
	g := persistence.NormalsFindFirstByYearAndLocation(request.BuildLocation())
	var returnGdds models.GddResponse
	if product == enums.ProductType.CORN {
		returnGdds = models.GddResponse{
			Product:          product.Name,
			ClosestLatitude:  g.Location.Coordinates[1],
			ClosestLongitude: g.Location.Coordinates[0],
			GddValues:        utils.CalculateNormalGddValues(g.CornBase, product, request.Accumulate),
		}
	} else {
		returnGdds = models.GddResponse{
			Product:          product.Name,
			ClosestLatitude:  g.Location.Coordinates[1],
			ClosestLongitude: g.Location.Coordinates[0],
			GddValues:        utils.CalculateNormalGddValues(g.GddBase, product, request.Accumulate),
		}
	}
	return returnGdds
}
