package utils

import (
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models/enums"
)

func CalculateSingleGdd(minTemp float64, maxTemp float64, product enums.Product) float64 {
	if product.Name == "CORN" {
		minTemp = ClipFloat(minTemp, 50, 86)
		maxTemp = ClipFloat(maxTemp, 50, 86)
	}
	mean := (maxTemp + minTemp) / 2.0
	value := mean - product.BaseTemp
	if product.Name == "CORN" {
		return value
	}
	value = ClipMinFloat(value, 0)
	return value
}

func CalculateNormalGddValues(base []float64, product enums.Product, accumulate bool) []float64 {
	var returnList []float64
	for i := 0; i < len(base); i++ {
		value := base[i] - product.BaseTemp
		value = ClipMinFloat(value, 0)
		if accumulate && i > 0 {
			value += returnList[len(returnList)-1]
		}
		returnList = append(returnList, value)
	}
	return returnList
}

func CalculateGddValues(minTemps []float64, maxTemps []float64, product enums.Product, accumulate bool) []float64 {
	var returnList []float64
	for i := 0; i < len(minTemps); i++ {
		value := CalculateSingleGdd(minTemps[i], maxTemps[i], product)
		if accumulate && i > 0 {
			value += returnList[len(returnList)-1]
		}
		returnList = append(returnList, value)
	}
	return returnList
}
