package enums

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestProduct(t *testing.T) {
	testTable := make(map[string]string)
	testTable["corn"] = "CORN"
	testTable["coRn"] = "CORN"
	testTable["soybean"] = "SOYBEAN"
	testTable["sunflower"] = "SUNFLOWER"
	testTable["tomato"] = "TOMATO"
	testTable["sugar_beet"] = "SUGAR_BEET"
	testTable["peanut"] = "PEANUT"
	testTable["cotton"] = "COTTON"
	testTable["potato"] = "POTATO"
	testTable["wheat"] = "WHEAT"
	testTable["pea"] = "PEA"
	testTable["oat"] = "OAT"
	testTable["spring_wheat"] = "SPRING_WHEAT"
	testTable["rice"] = "RICE"
	testTable["sorghum"] = "SORGHUM"

	for k := range testTable {
		assert.Equal(t, testTable[k], GetProductFromString(k).Name)
	}
}
