package services

import (
	"time"

	"github.com/tgs266/dawn-go-common/common"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models/enums"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence/entities"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/utils"
	"gonum.org/v1/gonum/stat"
)

func GetFullYearGddValues(ctx common.DawnCtx, request models.GddRequest) models.GddResponse {
	product := enums.GetProductFromString(request.Product)
	var gdds entities.Gdd
	if request.Year == time.Now().Year() {
		gdds = persistence.CurrentGddFindFirstByYearAndLocation(ctx, request.BuildLocation())
		gdds2 := persistence.CfsFindAllByLocation(request.BuildLocation())
		gdds.MaxTemps = append(gdds.MaxTemps, gdds2.MaxTemps...)
		gdds.MinTemps = append(gdds.MinTemps, gdds2.MinTemps...)
	} else {
		gdds = persistence.GddFindFirstByYearAndLocation(request.Year, request.BuildLocation())
	}
	returnGdds := models.GddResponse{
		Product:          product.Name,
		ClosestLatitude:  gdds.Location.Coordinates[1],
		ClosestLongitude: gdds.Location.Coordinates[0],
		GddValues:        utils.CalculateGddValues(gdds.MinTemps, gdds.MaxTemps, product, request.Accumulate),
		LastDate:         gdds.LastDate.Time(),
	}
	return returnGdds
}

func GetGddValues(ctx common.DawnCtx, request models.GddRequest) models.GddResponse {
	product := enums.GetProductFromString(request.Product)
	var gdds entities.Gdd
	if request.Year == time.Now().Year() {
		gdds = persistence.CurrentGddFindFirstByYearAndLocation(ctx, request.BuildLocation())
	} else {
		gdds = persistence.GddFindFirstByYearAndLocation(request.Year, request.BuildLocation())
	}
	returnGdds := models.GddResponse{
		Product:          product.Name,
		ClosestLatitude:  gdds.Location.Coordinates[1],
		ClosestLongitude: gdds.Location.Coordinates[0],
		GddValues:        utils.CalculateGddValues(gdds.MinTemps, gdds.MaxTemps, product, request.Accumulate),
		LastDate:         gdds.LastDate.Time(),
	}
	return returnGdds
}

func GetNormalValues(request models.GddRequest) models.GddResponse {
	product := enums.GetProductFromString(request.Product)
	gs := persistence.GetLastNormalsYearly(request.BuildLocation())
	var returnGdds models.GddResponse
	var gdds []float64
	rows := [][]float64{}
	for i := 0; i < len(gs[0].MinTemps); i++ { //; i++ {
		row := []float64{}
		for j := 0; j < len(gs); j++ {
			row = append(row, utils.CalculateSingleGdd(gs[j].MinTemps[i], gs[j].MaxTemps[i], product))
			if request.Accumulate && i > 0 {
				row[j] += rows[len(rows)-1][j]
			}
		}
		rows = append(rows, row)
		mean := stat.Mean(row, nil)
		gdds = append(gdds, mean)
	}

	returnGdds = models.GddResponse{
		Product:          product.Name,
		ClosestLatitude:  gs[0].Location.Coordinates[1],
		ClosestLongitude: gs[0].Location.Coordinates[0],
		GddValues:        gdds,
	}

	return returnGdds
}
