package controllers

import (
	"github.com/gofiber/fiber/v2"
	"github.com/tgs266/dawn-go-common/common"
	_ "github.com/tgs266/dawn-go-common/errors"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/services"
)

// ForecastStages godoc
// @Summary Get stages
// @Tags Forecast
// @Description Get stages
// @Accept  json
// @Produce  json
// @Success 200 {object} map[string]models.Bins
// @Failure 400 {object} errors.StandardError
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Param plant_date query string true "Plant date, ISO8601 or RFC3339 format"
// @Param mode query string true "Mode, rm or gdds_to_maturity"
// @Param value query int true "Value of mode"
// @Param anchor_stage query string false "anchoring stage"
// @Param anchor_date query string false "anchoring date"
// @Param comparison query int false "comparison. -1 for normals, or any int between 1981 and 2021 for a single year"
// @Router /gdd/forecast/stages [get]
func ForecastStages(c *fiber.Ctx) error {
	ctx := common.DawnCtx{FiberCtx: c}
	request := models.BuildStageRequest(ctx)

	return c.Status(fiber.StatusOK).JSON(services.CalculateStages(ctx, request))
}

// ForecastFreezingDates godoc
// @Summary Get stages
// @Tags Forecast
// @Description Get stages
// @Accept  json
// @Produce  json
// @Success 200 {object} map[string][]time.Time
// @Failure 400 {object} errors.StandardError
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Param freezing_temp query number true "Freezing temperature to use"
// @Router /gdd/forecast/freezing [get]
func ForecastFreezingDates(c *fiber.Ctx) error {
	ctx := common.DawnCtx{FiberCtx: c}
	request := models.BuildFreezingForecastRequest(ctx)

	return c.Status(fiber.StatusOK).JSON(services.ForecastFirstLastFreeze(ctx, request))
}
