package controllers

import (
	_ "github.com/tgs266/dawn-go-common/errors"

	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/services"

	"github.com/gofiber/fiber/v2"
)

// GetGefs godoc
// @Summary Get GDD values calculated from GEFS
// @Tags Gdd
// @Description Get GDD values calculated from GEFS
// @Accept  json
// @Produce  json
// @Success 200 {object} models.GefsGddResponse
// @Failure 400 {object} errors.StandardError
// @Param product query string true "Crop to calculate gdd for" Enums(corn, soybean, sunflower, tomato, sugar_beet, peanut, cotton, potato, wheat, pea, oat, spring_wheat, rice, sorghum)
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Param accumulate query boolean true "Accumulate gdd values"
// @Router /gdd/gefs [get]
func GetGefsGDD(c *fiber.Ctx) error {
	request := models.BuildGddRequest(c)
	return c.Status(fiber.StatusOK).JSON(services.GetGefsGddValues(request))
}

// GetCfsGDD godoc
// @Summary Get GDD values calculated from CFS
// @Tags Gdd
// @Description Get GDD values calculated from CFS
// @Accept  json
// @Produce  json
// @Success 200 {object} models.CfsGddResponse
// @Failure 400 {object} errors.StandardError
// @Param product query string true "Crop to calculate gdd for" Enums(corn, soybean, sunflower, tomato, sugar_beet, peanut, cotton, potato, wheat, pea, oat, spring_wheat, rice, sorghum)
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Param accumulate query boolean true "Accumulate gdd values"
// @Router /gdd/cfs [get]
func GetCfsGDD(c *fiber.Ctx) error {
	request := models.BuildGddRequest(c)
	return c.Status(fiber.StatusOK).JSON(services.GetCfsGddValues(request))
}

// // GetCfsFreezingDate godoc
// // @Summary Get predicted freezing date from CFS
// // @Tags Gdd
// // @Description Get GDD values calculated from CFS
// // @Accept  json
// // @Produce  json
// // @Success 200 {object} models.CfsGddResponse
// // @Failure 400 {object} errors.StandardError
// // @Param product query string true "Crop to calculate gdd for" Enums(corn, soybean, sunflower, tomato, sugar_beet, peanut, cotton, potato, wheat, pea, oat, spring_wheat, rice, sorghum)
// // @Param latitude query number true "Latitude to search for"
// // @Param longitude query number true "Longitude to search for"
// // @Param accumulate query boolean true "Accumulate gdd values"
// // @Router /gdd/cfs [get]
// func GetCfsFreezingDate(c *fiber.Ctx) error {
// 	request := models.GddRequest{}.Build(c)
// 	return c.Status(fiber.StatusOK).JSON(services.GetCfsGddValues(request))
// }
