package models

import validation "github.com/go-ozzo/ozzo-validation"

type AnalogResponse struct {
	ClosestLatitude  float64 `json:"closest_latitude"`
	ClosestLongitude float64 `json:"closest_longitude"`
	AnalogYear       int     `json:"analog_year"`
}

func ValidateAnalogRequest(latitude float64, longitude float64) error {
	err1 := validation.Validate(latitude, validation.Required, validation.Min(-90.0), validation.Max(90.0))
	err2 := validation.Validate(longitude, validation.Required, validation.Min(-180.0), validation.Max(180.0))
	if err1 != nil {
		return err1
	}
	if err2 != nil {
		return err2
	}
	return nil
}
