package services

import (
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence/entities"
)

func mockGefsFindAllByLocation(location entities.Location) []entities.GefsGdd {
	var arr []entities.GefsGdd

	filler := entities.GefsGdd{
		ID: "id",
		Location: entities.Location{
			Type:        "point",
			Coordinates: []float64{12.0, 12.0},
		},
		MinTemp: 45.0,
		MaxTemp: 76.0,
		VarMin:  1.0,
		VarMax:  1.0,
		Date:    215342634,
	}

	arr = append(arr,
		entities.GefsGdd{
			ID: "id",
			Location: entities.Location{
				Type:        "point",
				Coordinates: []float64{12.0, 12.0},
			},
			MinTemp: 45.0,
			MaxTemp: 76.0,
			VarMin:  1.0,
			VarMax:  1.0,
			Date:    215342634,
		},
	)

	arr = append(arr,
		entities.GefsGdd{
			ID: "id",
			Location: entities.Location{
				Type:        "point",
				Coordinates: []float64{12.0, 12.0},
			},
			MinTemp: 65.0,
			MaxTemp: 106.0,
			VarMin:  1.0,
			VarMax:  1.0,
			Date:    215342634,
		},
	)

	arr = append(arr,
		entities.GefsGdd{
			ID: "id",
			Location: entities.Location{
				Type:        "point",
				Coordinates: []float64{12.0, 12.0},
			},
			MinTemp: 23.0,
			MaxTemp: 45.0,
			VarMin:  1.0,
			VarMax:  1.0,
			Date:    215342634,
		},
	)

	for i := 0; i < 7; i++ {
		arr = append(arr, filler)
	}

	return arr
}

func mockCfsFindAllByLocation(location entities.Location) entities.CfsGdd {
	return entities.CfsGdd{
		ID: "id",
		Location: entities.Location{
			Type:        "point",
			Coordinates: []float64{12.0, 12.0},
		},
		MaxTemps: []float64{35.0, 55.0, 78.0},
		MinTemps: []float64{65.0, 43.0, 54.0},
		VarMin:   []float64{1.0, 1.0, 1.0},
		VarMax:   []float64{1.0, 1.0, 1.0},
		Date:     342653425,
	}
}

// func TestGetGefsGddValues(t *testing.T) {
// 	mock := DawnTest.CreateMock(persistence.GefsFindAllByLocation, mockGefsFindAllByLocation)
// 	defer mock.Unpatch()

// 	request := models.GddRequest{
// 		Product:    "soybean",
// 		Latitude:   12.0,
// 		Longitude:  12.0,
// 		Year:       2020,
// 		Accumulate: false,
// 	}

// 	gdds := GetGefsGddValues(request)
// 	assert.Equal(t, 10.5, gdds.GddValues[0], "must equal")
// 	assert.Equal(t, 0.0, gdds.GddValues[2], "must equal")
// }

// func TestGetGefsGddValuesAccumulate(t *testing.T) {
// 	mock := DawnTest.CreateMock(persistence.GefsFindAllByLocation, mockGefsFindAllByLocation)
// 	defer mock.Unpatch()

// 	request := models.GddRequest{
// 		Product:    "soybean",
// 		Latitude:   12.0,
// 		Longitude:  12.0,
// 		Year:       2020,
// 		Accumulate: true,
// 	}

// 	gdds := GetGefsGddValues(request)
// 	assert.Equal(t, 10.5, gdds.GddValues[0], "must equal")
// 	assert.Equal(t, 46.0, gdds.GddValues[2], "must equal")
// }

// func TestGetCefsGddValues(t *testing.T) {
// 	mock := DawnTest.CreateMock(persistence.CfsFindAllByLocation, mockCfsFindAllByLocation)
// 	defer mock.Unpatch()

// 	request := models.GddRequest{
// 		Product:    "soybean",
// 		Latitude:   12.0,
// 		Longitude:  12.0,
// 		Year:       2020,
// 		Accumulate: false,
// 	}

// 	gdds := GetCfsGddValues(request)
// 	assert.Equal(t, 0.0, gdds.GddValues[0], "must equal")
// 	assert.Equal(t, 16.0, gdds.GddValues[2], "must equal")
// }

// func TestGetCefsGddValuesAccumulate(t *testing.T) {
// 	mock := DawnTest.CreateMock(persistence.CfsFindAllByLocation, mockCfsFindAllByLocation)
// 	defer mock.Unpatch()

// 	request := models.GddRequest{
// 		Product:    "corn",
// 		Latitude:   12.0,
// 		Longitude:  12.0,
// 		Year:       2020,
// 		Accumulate: true,
// 	}

// 	gdds := GetCfsGddValues(request)
// 	assert.Equal(t, 7.5, gdds.GddValues[0], "must equal")
// 	assert.Equal(t, 26.0, gdds.GddValues[2], "must equal")
// }
