package utils

import (
	"time"
)

func isLeapYear(year int) bool {
	if (year % 4) == 0 {
		if (year % 100) == 0 {
			if (year % 400) == 0 {
				return true
			} else {
				return false
			}
		} else {
			return true
		}
	} else {
		return false
	}
}

func ConvertDateIdxToDate(idx int) time.Time {
	idx -= 1
	date := time.Date(time.Now().Year(), time.January, 1, 0, 0, 0, 0, time.UTC)
	date = date.Add(time.Duration(24*idx) * time.Hour)
	if isLeapYear(time.Now().Year()) {
		date = date.Add(time.Duration(-24) * time.Hour)
	}
	return date
}

func ConvertDateIdxToDateWithPlantingDate(plantingDate time.Time, idx int) time.Time {
	date := plantingDate
	date = date.Add(time.Duration(24*idx) * time.Hour)
	if isLeapYear(time.Now().Year()) && plantingDate.Before(time.Date(time.Now().Year(), time.March, 1, 0, 0, 0, 0, time.UTC)) {
		date = date.Add(time.Duration(-24) * time.Hour)
	}
	return date
}

func DaysSince(since, date time.Time) int {
	return int(date.Sub(since).Hours() / 24)
}

func GetFirstOfTheYear() time.Time {
	return GetFirstOfTheYearForYear(time.Now().Year())
}

func GetFirstOfTheYearForYear(year int) time.Time {
	return time.Date(year, time.January, 1, 0, 0, 0, 0, time.UTC)
}

func SliceAsDate[T any](firstDate time.Time, sliceDate time.Time, data []T) ([]T, time.Time, int) {
	firstDateInt := 0
	sliceDateInt := DaysSince(firstDate, sliceDate)

	diff := sliceDateInt - firstDateInt
	if diff < 0 {
		return data, firstDate, -1
	} else if diff == 0 {
		return data, firstDate, -1
	} else if sliceDateInt >= len(data) {
		return []T{}, sliceDate, -1
	}

	return data[sliceDateInt:], sliceDate, sliceDateInt
}
