package config

import "github.com/tgs266/dawn-go-common/common"

func INVALID_PRODUCT(passedProduct string) *common.DawnError {
	return &common.DawnError{
		Name:        "INVALID_PRODUCT",
		Description: "Product type '" + passedProduct + "' is invalid",
		Code:        400,
	}
}

var BAD_REQUEST = &common.DawnError{
	Name:        "BAD_REQUEST",
	Description: "Bad request was submitted",
	Code:        400,
}

func SEED_TYPE_MISMATCH(passedSeed string, expectedSeed string) *common.DawnError {
	return &common.DawnError{
		Name:        "SEED_TYPE_MISMATCH",
		Description: "Seed '" + passedSeed + "' was not of expected seed type '" + expectedSeed + "'",
		Code:        400,
	}
}

var NO_DATA_FOUND = &common.DawnError{
	Name:        "NO_DATA_FOUND",
	Description: "No data found for request",
	Code:        404,
}

// 500s

var DATABSE_CONNECTION_ERROR = &common.DawnError{
	Name:        "DATABSE_CONNECTION_ERROR",
	Description: "Cannot connect to database",
	Code:        500,
}

var INTERNAL_SERVER_STANDARD_ERROR = &common.DawnError{
	Name:        "INTERNAL_SERVER_ERROR",
	Description: "Unkown internal server error occurred",
	Code:        500,
}

var DATE_PARSE_FAILURE = &common.DawnError{
	Name:        "DATE_PARSE_FAILURE",
	Description: "Date parse failure",
	Code:        500,
}

var FILE_CREATION_ERROR = &common.DawnError{
	Name:        "FILE_CREATION_ERROR",
	Description: "Could not create file",
	Code:        500,
}
