package services

import (
	"fmt"
	"time"

	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/config"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence/entities"
)

var may31st = 150
var sept1st = 243
var nov30th = 330

func isLeapYear(year int) bool {
	if (year % 4) == 0 {
		if (year % 100) == 0 {
			if (year % 400) == 0 {
				return true
			} else {
				return false
			}
		} else {
			return true
		}
	} else {
		return false
	}
}

func GetFreezingDate(request models.FreezingDateRequest) models.FreezingDateResponse {

	var freezingDates entities.FreezingDates
	freezingDates = persistence.FindFreezingDates(request.BuildLocation())

	firstDate := time.Date(1981, time.January, 1, 0, 0, 0, 0, time.UTC)

	tempIdx := -1

	for i := 0; i < len(freezingDates.AllowedTemps); i++ {
		if freezingDates.AllowedTemps[i] == request.FreezingTemp {
			tempIdx = i
		}
	}

	if tempIdx == -1 {
		panic(config.BAD_REQUEST)
	}

	firstDates := freezingDates.FirstDates[tempIdx]
	lastDates := freezingDates.LastDates[tempIdx]

	firstDateCounts := make(map[string]*models.SingleFreezingDate)
	for idx, row := range firstDates {
		if row == -1 {
			continue
		}
		date := firstDate.Add(time.Duration(24*row) * time.Hour)
		day := date.Day()
		month := int(date.Month())
		str := fmt.Sprintf("%02d", month) + "-" + fmt.Sprintf("%02d", day)
		if value, exist := firstDateCounts[str]; exist {
			value.IncreaseCount()
			value.AddYear(idx + 1981)
		} else {
			firstDateCounts[str] = &models.SingleFreezingDate{
				Count: 1,
				Years: []int{idx + 1981},
			}
		}
	}

	lastDateCounts := make(map[string]*models.SingleFreezingDate)
	for idx, row := range lastDates {
		if row == -1 {
			continue
		}
		date := firstDate.Add(time.Duration(24*row) * time.Hour)
		day := date.Day()
		month := int(date.Month())
		str := fmt.Sprintf("%02d", month) + "-" + fmt.Sprintf("%02d", day)
		if value, exist := lastDateCounts[str]; exist {
			value.IncreaseCount()
			value.AddYear(idx + 1981)
		} else {
			lastDateCounts[str] = &models.SingleFreezingDate{
				Count: 1,
				Years: []int{idx + 1981},
			}
		}
	}

	response := models.FreezingDateResponse{
		FirstDateCounts:  firstDateCounts,
		LastDateCounts:   lastDateCounts,
		ClosestLatitude:  freezingDates.Location.Coordinates[1],
		ClosestLongitude: freezingDates.Location.Coordinates[0],
	}

	return response
}
