package services

import (
	"testing"

	"github.com/stretchr/testify/assert"
	DawnTest "github.com/tgs266/dawn-go-common/testing"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence/entities"
)

func TestIsLeapYear(t *testing.T) {
	assert.True(t, isLeapYear(2000))
	assert.False(t, isLeapYear(1999))
	assert.True(t, isLeapYear(1980))
	assert.False(t, isLeapYear(1990))
}

func mockFindFreezingDates(loc entities.Location) entities.FreezingDates {
	var dateCounts [][]int
	var inner []int
	inner = append(inner, 0)
	inner = append(inner, 0)
	inner = append(inner, -1)
	inner = append(inner, -0)
	dateCounts = append(dateCounts, inner)
	return entities.FreezingDates{
		ID:           "id",
		Location:     loc,
		FirstDates:   dateCounts,
		LastDates:    dateCounts,
		AllowedTemps: []int{28},
	}
}

func TestGetFreezingDate(t *testing.T) {
	request := models.FreezingDateRequest{
		Latitude:     12.0,
		Longitude:    12.0,
		FreezingTemp: 28,
	}

	mock := DawnTest.CreateMock(persistence.FindFreezingDates, mockFindFreezingDates)
	defer mock.Unpatch()

	response := GetFreezingDate(request)
	assert.Equal(t, 3, response.FirstDateCounts["01-01"].Count)
}
