package controllers

import (
	"testing"

	"github.com/gofiber/fiber/v2"
	"github.com/stretchr/testify/assert"
	DawnTest "github.com/tgs266/dawn-go-common/testing"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/services"
)

func mockGetFreezingDate(request models.FreezingDateRequest) models.FreezingDateResponse {
	dateCounts := make(map[string]*models.SingleFreezingDate)
	dateCounts["one"] = &models.SingleFreezingDate{
		Count: 1,
		Years: []int{2021},
	}
	return models.FreezingDateResponse{
		ClosestLatitude:  request.Latitude,
		ClosestLongitude: request.Longitude,
		FirstDateCounts:  dateCounts,
		LastDateCounts:   dateCounts,
	}
}

func TestGetFreezingDates(t *testing.T) {
	mock := DawnTest.CreateMock(services.GetFreezingDate, mockGetFreezingDate)
	defer mock.Unpatch()
	app := fiber.New()
	app.Get("/test", GetFreezingDates)
	var data models.FreezingDateResponse

	params := make(map[string]string)
	params["latitude"] = "12.0"
	params["longitude"] = "12.0"
	params["freezing_temp"] = "28"

	statusCode := DawnTest.TestGetRequestParams(app, "/test", params, "token", &data)

	DawnTest.StatusCodeEqual(t, 200, statusCode)
	assert.Equal(t, 2021, data.FirstDateCounts["one"].Years[0], "should match")
	assert.Equal(t, 1, data.FirstDateCounts["one"].Count, "should match")
}
