package controllers

import (
	"github.com/tgs266/dawn-go-common/common"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/services"

	"github.com/gofiber/fiber/v2"
)

var GetGddValues = services.GetGddValues

// GetDailyGdd godoc
// @Summary Get gdd values
// @Tags Gdd
// @Description get gdd values
// @Accept  json
// @Produce  json
// @Success 200 {object} models.GddResponse
// @Failure 400 {object} common.StandardError
// @Param year query int true "Year to get gdd for"
// @Param product query string true "Crop to calculate gdd for" Enums(corn, soybean, sunflower, tomato, sugar_beet, peanut, cotton, potato, wheat, pea, oat, spring_wheat, rice, sorghum)
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Param accumulate query boolean true "Accumulate gdd values"
// @Router /gdd/daily [get]
func GetDailyGdd(c *fiber.Ctx) error {
	ctx := common.DawnCtx{FiberCtx: c}
	request := models.BuildGddRequest(ctx.FiberCtx)
	return c.Status(fiber.StatusOK).JSON(GetGddValues(ctx, request))
}

// GetNormalGdd godoc
// @Summary Get gdd normals
// @Tags Gdd
// @Description get gdd normals
// @Accept  json
// @Produce  json
// @Success 200 {object} models.GddResponse
// @Failure 400 {object} common.StandardError
// @Param product query string true "Crop to calculate gdd for" Enums(corn, soybean, sunflower, tomato, sugar_beet, peanut, cotton, potato, wheat, pea, oat, spring_wheat, rice, sorghum)
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Param accumulate query boolean true "Accumulate gdd values"
// @Router /gdd/normals [get]
func GetNormalGdd(c *fiber.Ctx) error {
	request := models.BuildGddRequest(c)
	return c.Status(fiber.StatusOK).JSON(services.GetNormalValues(request))
}
