// Package docs GENERATED BY THE COMMAND ABOVE; DO NOT EDIT
// This file was generated by swaggo/swag
package docs

import (
	"bytes"
	"encoding/json"
	"strings"
	"text/template"

	"github.com/swaggo/swag"
)

var doc = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{escape .Description}}",
        "title": "{{.Title}}",
        "contact": {
            "name": "API Support",
            "email": "tgsiegel@umd.edu"
        },
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/freezing-dates": {
            "get": {
                "description": "get freezing dates",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Freezing Dates"
                ],
                "summary": "get freezing dates",
                "parameters": [
                    {
                        "type": "number",
                        "description": "Latitude to search for",
                        "name": "latitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Longitude to search for",
                        "name": "longitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Freezing temperature to use",
                        "name": "freezing_temp",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.FreezingDateResponse"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/common.StandardError"
                        }
                    }
                }
            }
        },
        "/gdd/analog": {
            "get": {
                "description": "Get analog year",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Gdd"
                ],
                "summary": "Get analog year",
                "parameters": [
                    {
                        "type": "number",
                        "description": "Latitude to search for",
                        "name": "latitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Longitude to search for",
                        "name": "longitude",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.AnalogResponse"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/common.StandardError"
                        }
                    }
                }
            }
        },
        "/gdd/cfs": {
            "get": {
                "description": "Get GDD values calculated from CFS",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Gdd"
                ],
                "summary": "Get GDD values calculated from CFS",
                "parameters": [
                    {
                        "enum": [
                            "corn",
                            "soybean",
                            "sunflower",
                            "tomato",
                            "sugar_beet",
                            "peanut",
                            "cotton",
                            "potato",
                            "wheat",
                            "pea",
                            "oat",
                            "spring_wheat",
                            "rice",
                            "sorghum"
                        ],
                        "type": "string",
                        "description": "Crop to calculate gdd for",
                        "name": "product",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Latitude to search for",
                        "name": "latitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Longitude to search for",
                        "name": "longitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "boolean",
                        "description": "Accumulate gdd values",
                        "name": "accumulate",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.CfsGddResponse"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/common.StandardError"
                        }
                    }
                }
            }
        },
        "/gdd/confidence": {
            "get": {
                "description": "Get confidence interval",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Gdd"
                ],
                "summary": "Get confidence interval",
                "parameters": [
                    {
                        "enum": [
                            "corn",
                            "soybean",
                            "sunflower",
                            "tomato",
                            "sugar_beet",
                            "peanut",
                            "cotton",
                            "potato",
                            "wheat",
                            "pea",
                            "oat",
                            "spring_wheat",
                            "rice",
                            "sorghum"
                        ],
                        "type": "string",
                        "description": "Crop to calculate gdd for",
                        "name": "product",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            80,
                            85,
                            90,
                            95,
                            99,
                            99.5,
                            99.9
                        ],
                        "type": "number",
                        "description": "Interval values",
                        "name": "Interval",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Latitude to search for",
                        "name": "latitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Longitude to search for",
                        "name": "longitude",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.ConfidenceIntervalResposne"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/common.StandardError"
                        }
                    }
                }
            }
        },
        "/gdd/csv": {
            "get": {
                "description": "Get gdd data csv",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "text/csv"
                ],
                "tags": [
                    "Gdd"
                ],
                "summary": "Get gdd data csv",
                "parameters": [
                    {
                        "type": "boolean",
                        "description": "Add analog data to csv",
                        "name": "analog",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Add cfs data to csv",
                        "name": "cfs",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Add cfs upper bound data to csv",
                        "name": "cfs_upper",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Add cfs lower bound data to csv",
                        "name": "cfs_lower",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Add comparison year data to csv",
                        "name": "comparison",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Add first freezing date data to csv",
                        "name": "first_freezing",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Add gefs data to csv",
                        "name": "gefs",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Add last freezing date data to csv",
                        "name": "last_freezing",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Add maximum boundary of confidence interval data to csv",
                        "name": "maximum",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Add minimum boundary of confidence interval data to csv",
                        "name": "minimum",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Add thirty year normal data to csv",
                        "name": "normals",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Add primary GDD data to csv",
                        "name": "primary",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Comparison year to use",
                        "name": "comparison_year",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "corn",
                            "soybean",
                            "sunflower",
                            "tomato",
                            "sugar_beet",
                            "peanut",
                            "cotton",
                            "potato",
                            "wheat",
                            "pea",
                            "oat",
                            "spring_wheat",
                            "rice",
                            "sorghum"
                        ],
                        "type": "string",
                        "description": "Crop to calculate gdd for",
                        "name": "product",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Confidence interval percentage",
                        "name": "range",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Freezing date temperature",
                        "name": "temperature",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Year to get primary data for",
                        "name": "year",
                        "in": "query"
                    },
                    {
                        "type": "number",
                        "description": "Latitude to search for",
                        "name": "latitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Longitude to search for",
                        "name": "longitude",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/common.StandardError"
                        }
                    }
                }
            }
        },
        "/gdd/daily": {
            "get": {
                "description": "get gdd values",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Gdd"
                ],
                "summary": "Get gdd values",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "Year to get gdd for",
                        "name": "year",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "corn",
                            "soybean",
                            "sunflower",
                            "tomato",
                            "sugar_beet",
                            "peanut",
                            "cotton",
                            "potato",
                            "wheat",
                            "pea",
                            "oat",
                            "spring_wheat",
                            "rice",
                            "sorghum"
                        ],
                        "type": "string",
                        "description": "Crop to calculate gdd for",
                        "name": "product",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Latitude to search for",
                        "name": "latitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Longitude to search for",
                        "name": "longitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "boolean",
                        "description": "Accumulate gdd values",
                        "name": "accumulate",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.GddResponse"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/common.StandardError"
                        }
                    }
                }
            }
        },
        "/gdd/gefs": {
            "get": {
                "description": "Get GDD values calculated from GEFS",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Gdd"
                ],
                "summary": "Get GDD values calculated from GEFS",
                "parameters": [
                    {
                        "enum": [
                            "corn",
                            "soybean",
                            "sunflower",
                            "tomato",
                            "sugar_beet",
                            "peanut",
                            "cotton",
                            "potato",
                            "wheat",
                            "pea",
                            "oat",
                            "spring_wheat",
                            "rice",
                            "sorghum"
                        ],
                        "type": "string",
                        "description": "Crop to calculate gdd for",
                        "name": "product",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Latitude to search for",
                        "name": "latitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Longitude to search for",
                        "name": "longitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "boolean",
                        "description": "Accumulate gdd values",
                        "name": "accumulate",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.GefsGddResponse"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/common.StandardError"
                        }
                    }
                }
            }
        },
        "/gdd/maturity/corn": {
            "get": {
                "description": "Get expected maturity date",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Maturity"
                ],
                "summary": "Get expected maturity date",
                "parameters": [
                    {
                        "type": "number",
                        "description": "Latitude to search for",
                        "name": "latitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Longitude to search for",
                        "name": "longitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Platning month",
                        "name": "plant_month",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Platning date",
                        "name": "plant_date",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Name of cultivar",
                        "name": "var_name",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "ID# of cultivar",
                        "name": "var_num",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Eco# of cultivar",
                        "name": "eco_num",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "P1 value of cultivar",
                        "name": "p1",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "P2 value of cultivar",
                        "name": "p2",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "P5 value of cultivar",
                        "name": "p5",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "G2 value of cultivar",
                        "name": "g2",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "G3 value of cultivar",
                        "name": "g3",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "PHINT value of cultivar",
                        "name": "phint",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.CornMaturityResponse"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/common.StandardError"
                        }
                    }
                }
            }
        },
        "/gdd/maturity/corn/cultivars": {
            "get": {
                "description": "Get all generic corn cultivars",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Maturity"
                ],
                "summary": "Get all generic corn cultivars",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Name of cultivar to get",
                        "name": "name",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.CultivarResponse"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/common.StandardError"
                        }
                    }
                }
            }
        },
        "/gdd/maturity/corn/relative": {
            "get": {
                "description": "Get expected maturity date",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Maturity"
                ],
                "summary": "Get expected maturity date",
                "parameters": [
                    {
                        "type": "number",
                        "description": "Latitude to search for",
                        "name": "latitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Longitude to search for",
                        "name": "longitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Platning month",
                        "name": "plant_month",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Platning date",
                        "name": "plant_date",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "RM of seed",
                        "name": "relative_maturity",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.CornMaturityResponse"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/common.StandardError"
                        }
                    }
                }
            }
        },
        "/gdd/normals": {
            "get": {
                "description": "get gdd normals",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Gdd"
                ],
                "summary": "Get gdd normals",
                "parameters": [
                    {
                        "enum": [
                            "corn",
                            "soybean",
                            "sunflower",
                            "tomato",
                            "sugar_beet",
                            "peanut",
                            "cotton",
                            "potato",
                            "wheat",
                            "pea",
                            "oat",
                            "spring_wheat",
                            "rice",
                            "sorghum"
                        ],
                        "type": "string",
                        "description": "Crop to calculate gdd for",
                        "name": "product",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Latitude to search for",
                        "name": "latitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Longitude to search for",
                        "name": "longitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "boolean",
                        "description": "Accumulate gdd values",
                        "name": "accumulate",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/models.GddResponse"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/common.StandardError"
                        }
                    }
                }
            }
        },
        "/gdd/stages": {
            "get": {
                "description": "Get stages",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Maturity"
                ],
                "summary": "Get stages",
                "parameters": [
                    {
                        "type": "number",
                        "description": "Latitude to search for",
                        "name": "latitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "number",
                        "description": "Longitude to search for",
                        "name": "longitude",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Plant date, ISO8601 or RFC3339 format",
                        "name": "plant_date",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Mode, rm or gdds_to_maturity",
                        "name": "mode",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "Value of mode",
                        "name": "value",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "object",
                            "additionalProperties": {
                                "type": "array",
                                "items": {
                                    "type": "string"
                                }
                            }
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/common.StandardError"
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "common.StandardError": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "details": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "errorCode": {
                    "type": "string"
                },
                "source": {
                    "type": "string"
                }
            }
        },
        "models.AnalogResponse": {
            "type": "object",
            "properties": {
                "analog_year": {
                    "type": "integer"
                },
                "closest_latitude": {
                    "type": "number"
                },
                "closest_longitude": {
                    "type": "number"
                }
            }
        },
        "models.CfsGddResponse": {
            "type": "object",
            "properties": {
                "closest_latitude": {
                    "type": "number"
                },
                "closest_longitude": {
                    "type": "number"
                },
                "first_date": {
                    "type": "string"
                },
                "gdd_values": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                },
                "lower_values": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                },
                "product": {
                    "type": "string"
                },
                "upper_values": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                }
            }
        },
        "models.ConfidenceIntervalResposne": {
            "type": "object",
            "properties": {
                "closest_latitude": {
                    "type": "number"
                },
                "closest_longitude": {
                    "type": "number"
                },
                "lower_bound": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                },
                "upper_bound": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                }
            }
        },
        "models.CornMaturityResponse": {
            "type": "object",
            "properties": {
                "harvest_date": {
                    "type": "string"
                }
            }
        },
        "models.Cultivar": {
            "type": "object",
            "properties": {
                "eco_num": {
                    "type": "string"
                },
                "g2": {
                    "type": "number"
                },
                "g3": {
                    "type": "number"
                },
                "p1": {
                    "type": "number"
                },
                "p2": {
                    "type": "number"
                },
                "p5": {
                    "type": "number"
                },
                "phint": {
                    "type": "number"
                },
                "var_name": {
                    "type": "string"
                },
                "var_num": {
                    "type": "string"
                }
            }
        },
        "models.CultivarResponse": {
            "type": "object",
            "properties": {
                "cultivars": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/models.Cultivar"
                    }
                }
            }
        },
        "models.FreezingDateResponse": {
            "type": "object",
            "properties": {
                "closest_latitude": {
                    "type": "number"
                },
                "closest_longitude": {
                    "type": "number"
                },
                "first_date_counts": {
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/models.SingleFreezingDate"
                    }
                },
                "last_date_counts": {
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/models.SingleFreezingDate"
                    }
                }
            }
        },
        "models.GddResponse": {
            "type": "object",
            "properties": {
                "closest_latitude": {
                    "type": "number"
                },
                "closest_longitude": {
                    "type": "number"
                },
                "gdd_values": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                },
                "last_date": {
                    "type": "string"
                },
                "product": {
                    "type": "string"
                }
            }
        },
        "models.GefsGddResponse": {
            "type": "object",
            "properties": {
                "closest_latitude": {
                    "type": "number"
                },
                "closest_longitude": {
                    "type": "number"
                },
                "first_date": {
                    "type": "string"
                },
                "gdd_values": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                },
                "last_date": {
                    "type": "string"
                },
                "lower_values": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                },
                "product": {
                    "type": "string"
                },
                "upper_values": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                }
            }
        },
        "models.SingleFreezingDate": {
            "type": "object",
            "properties": {
                "count": {
                    "type": "integer"
                },
                "years": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                }
            }
        }
    }
}`

type swaggerInfo struct {
	Version     string
	Host        string
	BasePath    string
	Schemes     []string
	Title       string
	Description string
}

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = swaggerInfo{
	Version:     "",
	Host:        "",
	BasePath:    "",
	Schemes:     []string{},
	Title:       "Dawn GDD Service",
	Description: "All operations for GDD/Freezing Date data",
}

type s struct{}

func (s *s) ReadDoc() string {
	sInfo := SwaggerInfo
	sInfo.Description = strings.Replace(sInfo.Description, "\n", "\\n", -1)

	t, err := template.New("swagger_info").Funcs(template.FuncMap{
		"marshal": func(v interface{}) string {
			a, _ := json.Marshal(v)
			return string(a)
		},
		"escape": func(v interface{}) string {
			// escape tabs
			str := strings.Replace(v.(string), "\t", "\\t", -1)
			// replace " with \", and if that results in \\", replace that with \\\"
			str = strings.Replace(str, "\"", "\\\"", -1)
			return strings.Replace(str, "\\\\\"", "\\\\\\\"", -1)
		},
	}).Parse(doc)
	if err != nil {
		return doc
	}

	var tpl bytes.Buffer
	if err := t.Execute(&tpl, sInfo); err != nil {
		return doc
	}

	return tpl.String()
}

func init() {
	swag.Register("swagger", &s{})
}
