#!/usr/bin/env python
from datetime import datetime, timedelta
from collections import defaultdict 
import numpy as np
import mz, json, argparse


# def generate_DSSAT_config(var_num, var_name, eco_num, p1, p2, p5, g2, g3, phint):


#! DAYL      Day length on day of simulation (from sunrise to sunset) (hr)
#! DLAYR(L)   Soil thickness in layer L (cm)
#! LEAFNO  Number of oldest leaf per plant
#! LL(NL)     Soil water lower limit, cm3/cm3
#! NLAYR      Number of soil layers
#! PLTPOP     Plant population, no./m2
#! SDEPTH     Sowing depth, cm
#! SI1(6)     Water stress during a growth stage used for output
#! SI3(6)     Water stress during a growth stage used for output
#! SNOW  = Snow depth, mm
#! SRAD       Daily solar radiation, MJ/m2/day
#! SUMP       Cumulative plant growth during ISTAGE 4, g/plant
#! SW(NL)     Soil water content in layer, cm3/cm3
#! TMAX       Daily maximum temperature, C
#! TMIN       Daily minimum temperature, C
#! TWILEN     Twilight definition of daylength
#! XN         Number of oldest expanding leaf
#! YRDOY      Year and day of year
#! YRSIM      Year and day of year of first day of simulation

def execute(config, json_parameter_file, output_csv_name):
    refyear = "2021"
    with open(json_parameter_file) as f:
        params = json.load(f)

    plantdate = int(params["plantdate"])
    tmins = params["tmins"]
    tmaxs = params["tmaxs"]
    srads = params["srads"]
    rains = params["rains"]

    freedom_units = params["units"] == "F"

    ##INIT
    DAYL     = 12. 
    DLAYR    = 10.
    LEAFNO   = 20.
    LL       = 0.3
    NLAYR    = 1. 
    PLTPOP   = 5 
    SDEPTH   = 10.
    SNOW  = 0 
    SUMP  = 0 # we should use the plant growth value replace it 
    SW    =2.
    TWILEN =10 
    TWILEN =8 
    XN     =20 
    YRSIM  = int(f"{refyear}001") 
    # output
    EARS=0
    GPP=0
    ISDATE=0
    MDATE=0
    DTT = np.zeros(1)
    CUMDTT = np.zeros(1)
    SUMDTT = np.zeros(1)
    P3 = np.zeros(1)
    STGDOY = np.zeros(20,dtype=np.int32)
    ISTAGE = np.zeros(1, dtype=np.int32) 
    ISTAGE[0] = 7 # begin with 7
    YREMRG = np.zeros(1, dtype=np.int32) 
    CDAY = np.zeros(1, dtype=np.int32) 

    XNTI=0
    TLNO=0
    XSTAGE=0
    RUE=0
    KCAN=0
    KEP=0
    TSEN=0
    CDAY=0
    SeedFrac=0
    VegFrac=0

    gdd=0

    INIT = True
    yrdoy = 1
    df_out = defaultdict(list)

    for tmin, tmax, srad, rain in zip(tmins, tmaxs, srads, rains):
        doy = yrdoy
        yrdoy += 1
        if doy<plantdate:
            continue
        if INIT:
            dynamic = 1  
            INIT = False
        else:
            dynamic = -1  
        
        YRDOY  = f"{str(refyear)[-2:]}{str(yrdoy).rjust(3, '0')}"
        SRAD   = float(srad)
        TMAX   = float(tmax)
        TMIN   = float(tmin)
        RAIN   = float(rain)

        if freedom_units:
            TMAX = (TMAX - 32) * (5/9)
            TMIN = (TMIN - 32) * (5/9)

        
        mz.mz_phenol(config, dynamic,                             # !C
            DAYL,DLAYR,LEAFNO,LL,NLAYR,                            # !I
            SNOW, SRAD,SUMP,SW,TMAX,TMIN, TWILEN,          # !I
            XN,YRDOY,YRSIM,                                        # !I
            CUMDTT,DTT,EARS,GPP,ISDATE, ISTAGE,MDATE,STGDOY,SUMDTT,# !O
            XNTI,TLNO,XSTAGE,YREMRG,RUE,KCAN,KEP, P3, TSEN, CDAY,  # !O
            SeedFrac, VegFrac)   
                                              # !O
        YRDOY  = f"{refyear}{doy:03d}"

        df_out["DTT"].append(DTT[0])
        gdd = gdd+DTT[0]
        df_out["GDD"].append(gdd)
        df_out["SUMDTT"].append(SUMDTT[0])
        df_out["ISTAGE"].append(ISTAGE[0])
        df_out["YRDOY"].append(YRDOY)

    # df_out = pd.DataFrame.from_dict(df_out)
    # df_out.set_index("YRDOY").to_csv(output_csv_name)

def get_predicted_harvest(config, json_parameter_file):
    refyear = "2021"
    with open(json_parameter_file) as f:
        params = json.load(f)

    plantdate = int(params["plant_date"])
    tmins = params["tmins"]
    tmaxs = params["tmaxs"]
    srads = params["srads"]
    # rains = params["rains"]

    freedom_units = params["units"] == "F"

    ##INIT
    DAYL     = 12. 
    DLAYR    = 10.
    LEAFNO   = 20.
    LL       = 0.3
    NLAYR    = 1. 
    PLTPOP   = 5 
    SDEPTH   = 10.
    SNOW  = 0 
    SUMP  = 0 # we should use the plant growth value replace it 
    SW    =2.
    TWILEN =10 
    TWILEN =8 
    XN     =20 
    YRSIM  = int(f"{refyear}001") 
    # output
    EARS=0
    GPP=0
    ISDATE=0
    MDATE=0
    DTT = np.zeros(1)
    CUMDTT = np.zeros(1)
    SUMDTT = np.zeros(1)
    P3 = np.zeros(1)
    STGDOY = np.zeros(20,dtype=np.int32)
    ISTAGE = np.zeros(1, dtype=np.int32) 
    ISTAGE[0] = 7 # begin with 7
    YREMRG = np.zeros(1, dtype=np.int32) 
    CDAY = np.zeros(1, dtype=np.int32) 

    XNTI=0
    TLNO=0
    XSTAGE=0
    RUE=0
    KCAN=0
    KEP=0
    TSEN=0
    CDAY=0
    SeedFrac=0
    VegFrac=0

    gdd=0

    INIT = True
    yrdoy = 1
    df_out = defaultdict(list)

    for tmin, tmax, srad in zip(tmins, tmaxs, srads):
        doy = yrdoy
        yrdoy += 1
        if doy<plantdate:
            continue
        if INIT:
            dynamic = 1  
            INIT = False
        else:
            dynamic = -1  
        
        YRDOY  = f"{str(refyear)[-2:]}{str(yrdoy).rjust(3, '0')}"
        SRAD   = float(srad)
        TMAX   = float(tmax)
        TMIN   = float(tmin)
        # RAIN   = float(rain)

        if freedom_units:
            TMAX = (TMAX - 32) * (5/9)
            TMIN = (TMIN - 32) * (5/9)

        
        mz.mz_phenol(config, dynamic,                             # !C
            DAYL,DLAYR,LEAFNO,LL,NLAYR,                            # !I
            SNOW, SRAD,SUMP,SW,TMAX,TMIN, TWILEN,          # !I
            XN,YRDOY,YRSIM,                                        # !I
            CUMDTT,DTT,EARS,GPP,ISDATE, ISTAGE,MDATE,STGDOY,SUMDTT,# !O
            XNTI,TLNO,XSTAGE,YREMRG,RUE,KCAN,KEP, P3, TSEN, CDAY,  # !O
            SeedFrac, VegFrac)   
                                              # !O
        YRDOY  = f"{refyear}{doy:03d}"

        if ISTAGE[0] == 6:
            return YRDOY

    return -1


# execute("test.json", "data.csv")

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='Process some integers.')
    parser.add_argument('--config', help='DSSAT config file')
    parser.add_argument('--input', help='input json file')
    parser.add_argument('--output', help='output csv file')
    parser.add_argument('--predicted', action='store_true')
    args = parser.parse_args()
    if args.predicted:
        print (get_predicted_harvest(int(args.config), args.input))
    else:
        execute(int(args.config), args.input, args.output)