package utils

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestClipInt(t *testing.T) {
	value := 10
	assert.Equal(t, value, ClipInt(value, 0, 11))
}

func TestClipIntLow(t *testing.T) {
	value := 4
	assert.Equal(t, 10, ClipInt(value, 10, 11))
}

func TestClipIntAbove(t *testing.T) {
	value := 100
	assert.Equal(t, 11, ClipInt(value, 10, 11))
}

func TestClipFloat(t *testing.T) {
	value := 10.0
	assert.Equal(t, value, ClipFloat(value, 0.0, 11.0))
}

func TestClipFloatLow(t *testing.T) {
	value := 4.0
	assert.Equal(t, 10.0, ClipFloat(value, 10.0, 11.0))
}

func TestClipFloatAbove(t *testing.T) {
	value := 100.0
	assert.Equal(t, 11.0, ClipFloat(value, 10.0, 11.0))
}
