package controllers

import (
	"github.com/tgs266/dawn-go-common/common"
	_ "github.com/tgs266/dawn-go-common/errors"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/services"

	"github.com/gofiber/fiber/v2"
)

var GetGddValues = services.GetGddValues

// GetDailyGdd godoc
// @Summary Get GDD Values for given year
// @Tags Gdd, public
// @Security ApiKeyAuth
// @Accept  json
// @Produce  json
// @Success 200 {object} models.GddResponse
// @Failure 400 {object} errors.StandardError
// @Failure 404 {object} errors.StandardError
// @Failure 500 {object} errors.StandardError
<<<<<<< controllers/gdd_controller.go
=======
// @Param year query int true "Year to get gdd for"
>>>>>>> controllers/gdd_controller.go
// @Param product query string true "Crop to calculate gdd for" Enums(corn)
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Param accumulate query boolean true "Accumulate gdd values"
// @Param plantingDate query string true "Plant date RFC3339 format"
// @Router /gdd/daily [get]
func GetDailyGdd(c *fiber.Ctx) error {
	ctx := common.DawnCtx{FiberCtx: c}
	request := models.BuildGddRequest(ctx.FiberCtx)
	return c.Status(fiber.StatusOK).JSON(GetGddValues(ctx, request))
}

// GetNormalGdd godoc
// @Summary Get GDD normals over the past 30 years
// @Tags Gdd, public
// @Security ApiKeyAuth
// @Accept  json
// @Produce  json
// @Success 200 {object} models.GddResponse
// @Failure 400 {object} errors.StandardError
// @Failure 404 {object} errors.StandardError
// @Failure 500 {object} errors.StandardError
// @Param product query string true "Crop to calculate gdd for" Enums(corn)
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Param accumulate query boolean true "Accumulate gdd values"
// @Param repeatYears query number false "number of times to repeat the request. When included with planting date, will extrapolate plantingdate -> end of repeatYears range"
// @Router /gdd/normals [get]
func GetNormalGdd(c *fiber.Ctx) error {
	request, repeat := models.BuildNormalsGddRequest(c)
	return c.Status(fiber.StatusOK).JSON(services.GetNormalValues(common.BuildCtx(c), request, repeat))
}
