package entities

type Normal struct {
	ID       string   `bson:"_id,omitempty"`
	Location Location `bson:"location,omitempty"`
	PrismLat int      `bson:"prism_lat,omitempty"`
	PrismLon int      `bson:"prism_lon,omitempty"`

	MinTemps    []float64 `bson:"min_temps,omitempty"`
	MaxTemps    []float64 `bson:"max_temps,omitempty"`
	MinVariance []float64 `bson:"min_variance,omitempty"`
	MaxVariance []float64 `bson:"max_variance,omitempty"`

	MinTempsCorn    []float64 `bson:"min_temps_corn,omitempty"`
	MaxTempsCorn    []float64 `bson:"max_temps_corn,omitempty"`
	MinVarianceCorn []float64 `bson:"min_variance_corn,omitempty"`
	MaxVarianceCorn []float64 `bson:"max_variance_corn,omitempty"`
	// GddBase  []float64 `bson:"global_normal_base,omitempty"`
	// CornBase []float64 `bson:"corn_normal_base,omitempty"`
	// GddMean  []float64 `bson:"global_mean,omitempty"`
	// CornMean []float64 `bson:"corn_mean,omitempty"`
	// GddStd   []float64 `bson:"global_std,omitempty"`
	// CornStd  []float64 `bson:"corn_std,omitempty"`
}
