package enums

import (
	"dawn-weather/config"
	"strings"
)

type Product struct {
	Name     string
	BaseTemp float64
}

type ProductList struct {
	CORN         Product
	SOYBEAN      Product
	SUNFLOWER    Product
	TOMATO       Product
	SUGAR_BEET   Product
	PEANUT       Product
	COTTON       Product
	POTATO       Product
	WHEAT        Product
	PEA          Product
	OAT          Product
	SPRING_WHEAT Product
	RICE         Product
	SORGHUM      Product
}

var ProductType = &ProductList{
	CORN:         Product{"CORN", 50.0},
	SOYBEAN:      Product{"SOYBEAN", 50.0},
	SUNFLOWER:    Product{"SUNFLOWER", 50.0},
	TOMATO:       Product{"TOMATO", 50.0},
	SUGAR_BEET:   Product{"SUGAR_BEET", 50.0},
	PEANUT:       Product{"PEANUT", 50.0},
	COTTON:       Product{"COTTON", 57.2},
	POTATO:       Product{"POTATO", 44.6},
	WHEAT:        Product{"WHEAT", 41.6},
	PEA:          Product{"PEA", 40.1},
	OAT:          Product{"OAT", 40.1},
	SPRING_WHEAT: Product{"SPRING_WHEAT", 32},
	RICE:         Product{"RICE", 46.4},
	SORGHUM:      Product{"SORGHUM", 46.4},
}

func GetProductFromString(productString string) Product {
	switch productString {
	case ProductType.CORN.Name:
	case strings.ToLower(ProductType.CORN.Name):
		return ProductType.CORN
	case ProductType.SOYBEAN.Name:
	case strings.ToLower(ProductType.SOYBEAN.Name):
		return ProductType.SOYBEAN
	case ProductType.SUNFLOWER.Name:
	case strings.ToLower(ProductType.SUNFLOWER.Name):
		return ProductType.SUNFLOWER
	case ProductType.TOMATO.Name:
	case strings.ToLower(ProductType.TOMATO.Name):
		return ProductType.TOMATO
	case ProductType.SUGAR_BEET.Name:
	case strings.ToLower(ProductType.SUGAR_BEET.Name):
		return ProductType.SUGAR_BEET
	case ProductType.PEANUT.Name:
	case strings.ToLower(ProductType.PEANUT.Name):
		return ProductType.PEANUT
	case ProductType.COTTON.Name:
	case strings.ToLower(ProductType.COTTON.Name):
		return ProductType.COTTON
	case ProductType.POTATO.Name:
	case strings.ToLower(ProductType.POTATO.Name):
		return ProductType.POTATO
	case ProductType.WHEAT.Name:
	case strings.ToLower(ProductType.WHEAT.Name):
		return ProductType.WHEAT
	case ProductType.PEA.Name:
	case strings.ToLower(ProductType.PEA.Name):
		return ProductType.PEA
	case ProductType.OAT.Name:
	case strings.ToLower(ProductType.OAT.Name):
		return ProductType.OAT
	case ProductType.SPRING_WHEAT.Name:
	case strings.ToLower(ProductType.SPRING_WHEAT.Name):
		return ProductType.SPRING_WHEAT
	case ProductType.RICE.Name:
	case strings.ToLower(ProductType.RICE.Name):
		return ProductType.RICE
	case ProductType.SORGHUM.Name:
	case strings.ToLower(ProductType.SORGHUM.Name):
		return ProductType.SORGHUM
	}
	panic(config.INVALID_PRODUCT(productString))
}
