package entities

import (
	"go.mongodb.org/mongo-driver/bson/primitive"
)

type Location struct {
	Type        string    `json:"type" bson:"type"`
	Coordinates []float64 `json:"coordinates" bson:"coordinates"`
}

type Gdd struct {
	ID         string             `bson:"_id,omitempty"`
	PrismLat   int                `bson:"prism_lat,omitempty"`
	PrismLon   int                `bson:"prism_lon,omitempty"`
	LastDate   primitive.DateTime `bson:"last_date,omitempty"`
	AnalogYear int                `bson:"analog_year,omitempty"`
	Year       int                `bson:"year,omitempty"`
	MinTemps   []float64          `bson:"min_temps,omitempty"`
	MaxTemps   []float64          `bson:"max_temps,omitempty"`
	Location   Location           `bson:"location,omitempty"`
}

type GefsGdd struct {
	ID       string             `bson:"_id,omitempty"`
	Location Location           `bson:"location,omitempty"`
	MinTemp  float64            `bson:"min_temp,omitempty"`
	MaxTemp  float64            `bson:"max_temp,omitempty"`
	VarMin   float64            `bson:"var_min,omitempty"`
	VarMax   float64            `bson:"var_max,omitempty"`
	Date     primitive.DateTime `bson:"date,omitempty"`
}

type CfsGdd struct {
	ID       string             `bson:"_id,omitempty"`
	Location Location           `bson:"location,omitempty"`
	MinTemps []float64          `bson:"min_temps,omitempty"`
	MaxTemps []float64          `bson:"max_temps,omitempty"`
	VarMin   []float64          `bson:"var_mins,omitempty"`
	VarMax   []float64          `bson:"var_maxs,omitempty"`
	Date     primitive.DateTime `bson:"date,omitempty"`
}
