package services

import (
	"dawn-weather/models"
	"dawn-weather/models/enums"
	"dawn-weather/persistence"
	"dawn-weather/utils"
	"math"
	"time"
)

func GetConfidenceInterval(request models.ConfidenceIntervalRequest) models.ConfidenceIntervalResposne {
	g := persistence.NormalsFindFirstByYearAndLocation(request.BuildLocation())

	var gddMean []float64
	var gddStd []float64

	var lowerBound []float64
	var upperBound []float64

	var gddMinSum float64
	var gddMaxSum float64

	if request.Product == enums.ProductType.CORN {
		gddMean = g.CornMean
		gddStd = g.CornStd
	} else {
		gddMean = g.GddMean
		gddStd = g.GddStd
	}

	totalYears := float64(time.Now().Year() - 1981)

	zScore := models.IntervalConvert[request.Interval]

	for i := 0; i < len(gddMean); i++ {
		gddValue := gddMean[i]

		maxGddValue := (gddValue + (gddStd[i] / (math.Pow(totalYears, 0.5)) * zScore)) - request.Product.BaseTemp
		minGddValue := (gddValue - (gddStd[i] / (math.Pow(totalYears, 0.5)) * zScore)) - request.Product.BaseTemp

		minGddValue = utils.ClipMinFloat(minGddValue, 0)
		maxGddValue = utils.ClipMinFloat(maxGddValue, 0)

		gddMinSum += minGddValue
		gddMaxSum += maxGddValue

		lowerBound = append(lowerBound, gddMinSum)
		upperBound = append(upperBound, gddMaxSum)
	}

	return models.ConfidenceIntervalResposne{
		LowerBound:       lowerBound,
		UpperBound:       upperBound,
		ClosestLatitude:  g.Location.Coordinates[1],
		ClosestLongitude: g.Location.Coordinates[0],
	}
}
