package services

import (
	"dawn-weather/config"
	"dawn-weather/models"
	"dawn-weather/persistence"
	"dawn-weather/persistence/entities"
	"fmt"
	"time"
)

var may31st = 150
var sept1st = 243
var nov30th = 330

func isLeapYear(year int) bool {
	if (year % 4) == 0 {
		if (year % 100) == 0 {
			if (year % 400) == 0 {
				return true
			} else {
				return false
			}
		} else {
			return true
		}
	} else {
		return false
	}
}

func GetFreezingDate(request models.FreezingDateRequest) models.FreezingDateResponse {

	var freezingDates entities.FreezingDates
	freezingDates = persistence.FindFreezingDates(request.BuildLocation())

	firstDate := time.Date(1981, time.January, 1, 0, 0, 0, 0, time.UTC)

	tempIdx := -1

	for i := 0; i < len(freezingDates.AllowedTemps); i++ {
		if freezingDates.AllowedTemps[i] == request.FreezingTemp {
			tempIdx = i
		}
	}

	if tempIdx == -1 {
		panic(config.BAD_REQUEST)
	}

	firstDates := freezingDates.FirstDates[tempIdx]
	lastDates := freezingDates.LastDates[tempIdx]

	firstDateCounts := make(map[string]int)
	for _, row := range firstDates {
		if row == -1 {
			continue
		}
		date := firstDate.Add(time.Duration(24*row) * time.Hour)
		day := date.Day()
		month := int(date.Month())
		str := fmt.Sprintf("%02d", month) + "-" + fmt.Sprintf("%02d", day)
		firstDateCounts[str]++
	}

	lastDateCounts := make(map[string]int)
	for _, row := range lastDates {
		if row == -1 {
			continue
		}
		date := firstDate.Add(time.Duration(24*row) * time.Hour)
		day := date.Day()
		month := int(date.Month())
		str := fmt.Sprintf("%02d", month) + "-" + fmt.Sprintf("%02d", day)
		lastDateCounts[str]++
	}

	response := models.FreezingDateResponse{
		FirstDateCounts:  firstDateCounts,
		LastDateCounts:   lastDateCounts,
		ClosestLatitude:  freezingDates.Location.Coordinates[1],
		ClosestLongitude: freezingDates.Location.Coordinates[0],
	}

	return response
}
