package config

import "github.com/tgs266/dawn-go-common/errors"

func INVALID_PRODUCT(passedProduct string) *errors.DawnError {
	return &errors.DawnError{
		Name:        "INVALID_PRODUCT",
		Description: "Product type '" + passedProduct + "' is invalid",
		Code:        400,
	}
}

var BAD_REQUEST = &errors.DawnError{
	Name:        "BAD_REQUEST",
	Description: "Bad request was submitted",
	Code:        400,
}

func SEED_TYPE_MISMATCH(passedSeed string, expectedSeed string) *errors.DawnError {
	return &errors.DawnError{
		Name:        "SEED_TYPE_MISMATCH",
		Description: "Seed '" + passedSeed + "' was not of expected seed type '" + expectedSeed + "'",
		Code:        400,
	}
}

var NO_DATA_FOUND = &errors.DawnError{
	Name:        "NO_DATA_FOUND",
	Description: "No data found for request",
	Code:        404,
}

// 500s

var DATABSE_CONNECTION_ERROR = &errors.DawnError{
	Name:        "DATABSE_CONNECTION_ERROR",
	Description: "Cannot connect to database",
	Code:        500,
}

var INTERNAL_SERVER_STANDARD_ERROR = &errors.DawnError{
	Name:        "INTERNAL_SERVER_ERROR",
	Description: "Unkown internal server error occurred",
	Code:        500,
}

var DATE_PARSE_FAILURE = &errors.DawnError{
	Name:        "DATE_PARSE_FAILURE",
	Description: "Date parse failure",
	Code:        500,
}

var FILE_CREATION_ERROR = &errors.DawnError{
	Name:        "FILE_CREATION_ERROR",
	Description: "Could not create file",
	Code:        500,
}
