package controllers

import (
	"github.com/tgs266/dawn-go-common/common"
	_ "github.com/tgs266/dawn-go-common/errors"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/services"

	"github.com/gofiber/fiber/v2"
)

// GetFreezingDates godoc
// @Summary get freezing dates
// @Tags Freezing Dates
// @Description get freezing dates
// @Accept  json
// @Produce  json
// @Success 200 {object} models.FreezingDateResponse
// @Failure 400 {object} errors.StandardError
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Param freezing_temp query number true "Freezing temperature to use"
// @Router /freezing-dates [get]
func GetFreezingDates(c *fiber.Ctx) error {
	request := models.FreezingDateRequest{}.Build(c)
	return c.Status(fiber.StatusOK).JSON(services.GetFreezingDate(common.BuildCtx(c), request))
}
