package repositories

import (
	"context"
	errs "errors"

	"github.com/tgs266/dawn-go-common/common"
	"github.com/tgs266/dawn-go-common/errors"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence/entities"
	"go.mongodb.org/mongo-driver/mongo"
)

type FreezingDatesRepository interface {
	FindFreezingDatesByLocation(ctx context.Context, location entities.Location) entities.FreezingDates
}

type freezingDatesRepositoryImpl struct {
	session *common.DBSession
}

func NewFreezingDatesRepository(session *common.DBSession) FreezingDatesRepository {
	return &freezingDatesRepositoryImpl{
		session: session,
	}
}

func (g *freezingDatesRepositoryImpl) FindFreezingDatesByLocation(ctx context.Context, location entities.Location) entities.FreezingDates {
	coll := g.session.Collection("freezing_dates")

	filter := buildLocationRequest(location, nil)

	var v entities.FreezingDates
	err := coll.FindOne(ctx, filter).Decode(&v)
	if errs.Is(err, mongo.ErrNoDocuments) {
		panic(errors.NewNotFound(err).PutDetail("reason", "freezing_dates"))
	} else if err != nil {
		panic(errors.NewInternal(err))
	}

	return v
}
