package services

import (
	"context"

	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/utils"
	"gonum.org/v1/gonum/stat"
)

func GetConfidenceInterval(ctx context.Context, request models.ConfidenceIntervalRequest) models.ConfidenceIntervalResposne {

	gs := persistence.GddRepository().FindGddsOverNormalsRangeByLocation(ctx, request.BuildLocation())
	product := request.Product
	// zScore := models.IntervalConvert[request.Interval]
	// zScore := models.IntervalConvertPercentiles[request.Interval]

	r := 1
	if request.RepeatYears > 0 {
		r = request.RepeatYears
	}

	var lowerBound []float64
	var upperBound []float64

	// get the int of the planting date. If the date is less than the first date, we do nothing
	// otherwise, we adjust
	// need to do before because of accumulations
	sliceDateInt := request.PlantingDate.YearDay() - 1
	if sliceDateInt < 0 {
		sliceDateInt = 0
	}

	rows := [][]float64{}
	for i := sliceDateInt; i < len(gs[0].MinTemps)*r; i++ {
		row := []float64{}
		idx := i
		if i >= len(gs[0].MinTemps) {
			idx -= len(gs[0].MinTemps)
		}
		for j := 0; j < len(gs); j++ {
			row = append(row, utils.CalculateSingleGdd(gs[j].MinTemps[idx], gs[j].MaxTemps[idx], product))
			if i > sliceDateInt {
				row[j] += rows[len(rows)-1][j]
			}
		}
		rows = append(rows, row)
		mean, std := stat.MeanStdDev(row, nil)
		moe := std * 1.645
		// moe := std / math.Pow(30, 0.5) * zScore

		upperBound = append(upperBound, utils.ClipMinFloat(mean+moe, 0))
		lowerBound = append(lowerBound, utils.ClipMinFloat(mean-moe, 0))
	}
	return models.ConfidenceIntervalResposne{
		LowerBound:       lowerBound,
		UpperBound:       upperBound,
		ClosestLatitude:  gs[0].Location.Coordinates[1],
		ClosestLongitude: gs[0].Location.Coordinates[0],
	}
}
