package controllers

import (
	"strconv"

	_ "github.com/tgs266/dawn-go-common/errors"

	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/config"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence/entities"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/services"

	"github.com/gofiber/fiber/v2"
)

// GetAnalogYear godoc
// @Summary Get analog year
// @Tags Gdd
// @Description Get analog year
// @Accept  json
// @Produce  json
// @Success 200 {object} models.AnalogResponse
// @Failure 400 {object} errors.StandardError
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Router /gdd/analog [get]
func GetAnalogYear(c *fiber.Ctx) error {
	lat, _ := strconv.ParseFloat(c.Query("latitude", "-10000.0"), 64)
	lon, _ := strconv.ParseFloat(c.Query("longitude", "-10000.0"), 64)
	err := models.ValidateAnalogRequest(lat, lon)
	if err != nil {
		panic(config.BAD_REQUEST)
	}

	location := entities.Location{Type: "Point", Coordinates: []float64{lon, lat}}

	return c.Status(fiber.StatusOK).JSON(
		persistence.FindAnalogYear(location),
	)
}

// GetConfidenceInterval godoc
// @Summary Get confidence interval
// @Tags Gdd
// @Description Get confidence interval
// @Accept  json
// @Produce  json
// @Success 200 {object} models.ConfidenceIntervalResposne
// @Failure 400 {object} errors.StandardError
// @Param product query string true "Crop to calculate gdd for" Enums(corn, soybean, sunflower, tomato, sugar_beet, peanut, cotton, potato, wheat, pea, oat, spring_wheat, rice, sorghum)
// @Param Interval query number true "Interval values" Enums(80, 85, 90, 95, 99, 99.5, 99.9)
// @Param latitude query number true "Latitude to search for"
// @Param longitude query number true "Longitude to search for"
// @Router /gdd/confidence [get]
func GetConfidenceInterval(c *fiber.Ctx) error {
	r := models.ConfidenceIntervalRequest{}.Build(c)
	return c.Status(fiber.StatusOK).JSON(services.GetConfidenceInterval(r))
}
