package services

import (
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/models"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/persistence"
	"gitlab.cs.umd.edu/dawn/go-backend/dawn-gdd/utils"
	"gonum.org/v1/gonum/stat"
)

func GetConfidenceInterval(request models.ConfidenceIntervalRequest) models.ConfidenceIntervalResposne {

	gs := persistence.GetLastNormalsYearly(request.BuildLocation())
	product := request.Product
	// zScore := models.IntervalConvert[request.Interval]
	// zScore := models.IntervalConvertPercentiles[request.Interval]

	var lowerBound []float64
	var upperBound []float64

	rows := [][]float64{}
	for i := 0; i < len(gs[0].MinTemps); i++ {
		row := []float64{}
		for j := 0; j < len(gs); j++ {
			row = append(row, utils.CalculateSingleGdd(gs[j].MinTemps[i], gs[j].MaxTemps[i], product))
			if i > 0 {
				row[j] += rows[len(rows)-1][j]
			}
		}
		rows = append(rows, row)
		mean, std := stat.MeanStdDev(row, nil)
		moe := std * 1.645
		// moe := std / math.Pow(30, 0.5) * zScore

		upperBound = append(upperBound, utils.ClipMinFloat(mean+moe, 0))
		lowerBound = append(lowerBound, utils.ClipMinFloat(mean-moe, 0))
	}
	return models.ConfidenceIntervalResposne{
		LowerBound:       lowerBound,
		UpperBound:       upperBound,
		ClosestLatitude:  gs[0].Location.Coordinates[1],
		ClosestLongitude: gs[0].Location.Coordinates[0],
	}
}
