package utils

import "time"

func isLeapYear(year int) bool {
	if (year % 4) == 0 {
		if (year % 100) == 0 {
			if (year % 400) == 0 {
				return true
			} else {
				return false
			}
		} else {
			return true
		}
	} else {
		return false
	}
}

func ConvertDateIdxToDate(idx int) time.Time {
	idx -= 1
	date := time.Date(time.Now().Year(), time.January, 1, 0, 0, 0, 0, time.UTC)
	date = date.Add(time.Duration(24*idx) * time.Hour)
	if isLeapYear(time.Now().Year()) {
		date = date.Add(time.Duration(-24) * time.Hour)
	}
	return date
}

func ConvertDateIdxToDateWithPlantingDate(plantingDate time.Time, idx int) time.Time {
	date := plantingDate
	date = date.Add(time.Duration(24*idx) * time.Hour)
	if isLeapYear(time.Now().Year()) && plantingDate.Before(time.Date(time.Now().Year(), time.March, 1, 0, 0, 0, 0, time.UTC)) {
		date = date.Add(time.Duration(-24) * time.Hour)
	}
	return date
}
