package main

import (
	"bufio"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"math/rand"
	"os"
	"os/signal"
	"strconv"
	"strings"
	"syscall"
	"time"

	"818f19/p5/solution/pb"

	. "github.com/mattn/go-getopt"
	"golang.org/x/net/context"
	"google.golang.org/grpc"
)

type ConfigAddr struct {
	Host string
	Port string
}

type ConfigFile struct {
	N        int
	Batching int
	Replicas []ConfigAddr
}

var (
	N          = 3
	configFile = "../config.json"
	debug      = false
	repID      = 0
	hostname   string
	identity   string
	servers    []pb.KVClient
	log        = []pb.CommandString{}
	store      = make(map[string]string)
	doPrint    = false
)

//=====================================================================

func main() {
	hostname, _ = os.Hostname()

	log = append(log, pb.CommandString{Slot: 1, Cmd: "1,1,r,A"})
	log = append(log, pb.CommandString{Slot: 1, Cmd: "1,2,w,A,nice"})
	store["foo"] = "bar"
	store["bar"] = "4 2"

	for {
		if c := Getopt("c:dN:pr:"); c == EOF {
			break
		} else {
			switch c {

			case 'c':
				configFile = OptArg

			case 'd':
				debug = !debug

			case 'N':
				N, _ = strconv.Atoi(OptArg)

			case 'p':
				doPrint = !doPrint

			case 'r':
				repID, _ = strconv.Atoi(OptArg)

			}
		}
	}

	//=====================================================================

	// Compute the identity
	if hostname != "" {
		identity = fmt.Sprintf("%s-%04X-", hostname, rand.Intn(0x10000))
	} else {
		identity = fmt.Sprintf("%04X-%04X-", rand.Intn(0x10000), rand.Intn(0x10000))
	}

	//=====================================================================

	sigch := make(chan os.Signal, 1)
	signal.Notify(sigch, syscall.SIGTERM, os.Interrupt, os.Kill)
	go func() {
		<-sigch
		writelog()
	}()

	//=====================================================================
	config := new(ConfigFile)
	if dat, err := ioutil.ReadFile(configFile); err == nil {
		if err := json.Unmarshal(dat, config); err != nil {
			p_exit("Unable to unmarshal config: %v\n", err)
		}
	} else {
		p_exit("Unable to open config file: %v\n", err)
	}
	if N == 0 {
		N = config.N
	}

	servers = make([]pb.KVClient, N)
	for i := 0; i < N; i++ {
		addr := config.Replicas[i].Host + ":" + config.Replicas[i].Port
		conn, err := grpc.Dial(addr, grpc.WithInsecure())
		if err != nil {
			panic(fmt.Sprintf("did no t connect: %v", err))
		}
		p_out("Dialed %q\n", addr)
		servers[i] = pb.NewKVClient(conn)
	}

	//=====================================================================

	scanner := bufio.NewScanner(os.Stdin)
	for scanner.Scan() {
		l := strings.TrimSpace(scanner.Text())
		fmt.Printf("%s\n", l)

		var rep *pb.ClientReply
		var err error

		if strings.HasPrefix(l, "pause ") {
			seconds, _ := strconv.Atoi(l[len("pause "):])
			time.Sleep(time.Duration(seconds) * time.Second)
		} else {
			if rep, err = servers[repID].Cmd(context.TODO(), &pb.CmdRequest{
				Identity: identity,
				Seen:     int64(len(log)),
				Cmd:      l,
			}); err != nil {
				p_exit("Send to server %v failed: %v\n", repID, err)
			}
			p_out("cmd reply %v\n", rep.Cmds)
		}

		// add to local log

		// interpret

	}
	writelog()
}

//=====================================================================
func writelog() {
	b, _ := json.MarshalIndent(log, "   ", "   ")
	p_err("\n%s\n", string(b))

	c, _ := json.MarshalIndent(store, "   ", "   ")
	p_err("\n%s\n", string(c))

	ioutil.WriteFile(fmt.Sprintf("output.client"), b, 0644)
	os.Exit(1)
}

func p_out(s string, args ...interface{}) {
	if !debug {
		return
	}
	fmt.Printf(s, args...)
}

func p_err(s string, args ...interface{}) {
	fmt.Printf(s, args...)
}

func p_exit(s string, args ...interface{}) {
	fmt.Printf(s, args...)
	os.Exit(1)
}
