# Assignment 4: Documents and a SwiftUI Map


## Goals
Learn to use:
- SwiftUI Map
- Core Location
- Core Data

You will build a biking or running GPS tracker app that saves and displays tracks
by browsing the local core data. We have posted a demo video of the app titled "assign4.mov" on Canvas. 

## Tasks

The following is a suggested series of steps for you to take, together
with approximate points that each step will be worth. You can ignore
all this and just emulate the demo video. Doing that gets you
full points. However, the following set of steps is a good approach to
building this app methodically.

## Step 1: Showing a Map (25 pts)

Go through the video on 10/26 for Core Location and using the SwiftUI Map object.
Display the static location of the user on a map. Core data was
discussed 10/14 and 10/19

## Step 2: Tracking the Rider (25 pts)

- Set up location updating to get location updates.
- Keep the user centered in the middle of the screen in a region with
  an appropriate zoom level. Do this by using the appropriate
  `userTrackingMode` in your `Map()` view initialization. This will
  make the  tracking smooth, not jerky.   

## Step 3: Drawing the Path Trajectory (25 pts)

- At each call of your `locationManager(manager:, didUpdateLocations:)`,
you will be given an array of one or more `CLLocation`s. Draw the trajectory
of all the points given in this call. 
- In the demo video, we implemented this using annotations. Feel free to use any method 
you deem appropriate. You will receive most of the credit as long as the view
indicates the taken path and looks decent. You will get more points if
you are able to use a `polyline` overlay over the `Map` object.

## Step 4: Saving and Viewing Tracks (25 pts)

Define a core data `Track` entity that contains, at a minimum, a name,
a timestamp, and a sequence of coordinates.

You will need to have routines to serialize to and from JSON, which is
cast as a `Data`, which is then written/read to/from the database.

## Hints:

- You can use the simple format specified below to store each track.

```
struct GPXPoint: Codable {
    var latitude: Double
    var longitude: Double
    var altitude: Double
    var time: Date
}

struct GPXSegment: Codable {
    var coords : [GPXPoint]
}

struct GPXTrack : Codable {
    var name : String
    var link : String
    var time : String
    var segments : [GPXSegment] = []
    var distance = "-"
    var feetClimbed = "-"
}
```

- The `Map` view, like all views, is a `struct`. Core location
requires a class instance, so you will have to have a class instancs
that exports location info through bound variables.

- Make sure you have added the required entry to the Info.plist file. Your app will require entries for accessing location data.

## Notes:

**Important**: Please avoid the usage of UIKit or any wrappers for UIKit views such as UIViewRepresentable. 
Using such packages would result in an automatic 0 in the respective
task. You should *not* use **MKMapView()**. Instead, use **Map()**.
- Might look [here]() for polygons. I have *not* verified this, might cause your laptop to go up in a puff of smoke, work great, or fail to compile.

